/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.PlaySourceInternal;
import com.azure.communication.callautomation.implementation.models.RecognizeInputTypeInternal;
import com.azure.communication.callautomation.implementation.models.RecognizeOptionsInternal;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class RecognizeRequest
implements JsonSerializable<RecognizeRequest> {
    private RecognizeInputTypeInternal recognizeInputType;
    private PlaySourceInternal playPrompt;
    private List<PlaySourceInternal> playPrompts;
    private Boolean interruptCallMediaOperation;
    private RecognizeOptionsInternal recognizeOptions;
    private String operationContext;
    private String operationCallbackUri;

    public RecognizeInputTypeInternal getRecognizeInputType() {
        return this.recognizeInputType;
    }

    public RecognizeRequest setRecognizeInputType(RecognizeInputTypeInternal recognizeInputType) {
        this.recognizeInputType = recognizeInputType;
        return this;
    }

    public PlaySourceInternal getPlayPrompt() {
        return this.playPrompt;
    }

    public RecognizeRequest setPlayPrompt(PlaySourceInternal playPrompt) {
        this.playPrompt = playPrompt;
        return this;
    }

    public List<PlaySourceInternal> getPlayPrompts() {
        return this.playPrompts;
    }

    public RecognizeRequest setPlayPrompts(List<PlaySourceInternal> playPrompts) {
        this.playPrompts = playPrompts;
        return this;
    }

    public Boolean isInterruptCallMediaOperation() {
        return this.interruptCallMediaOperation;
    }

    public RecognizeRequest setInterruptCallMediaOperation(Boolean interruptCallMediaOperation) {
        this.interruptCallMediaOperation = interruptCallMediaOperation;
        return this;
    }

    public RecognizeOptionsInternal getRecognizeOptions() {
        return this.recognizeOptions;
    }

    public RecognizeRequest setRecognizeOptions(RecognizeOptionsInternal recognizeOptions) {
        this.recognizeOptions = recognizeOptions;
        return this;
    }

    public String getOperationContext() {
        return this.operationContext;
    }

    public RecognizeRequest setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    public RecognizeRequest setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recognizeInputType", this.recognizeInputType == null ? null : this.recognizeInputType.toString());
        jsonWriter.writeJsonField("recognizeOptions", (JsonSerializable)this.recognizeOptions);
        jsonWriter.writeJsonField("playPrompt", (JsonSerializable)this.playPrompt);
        jsonWriter.writeArrayField("playPrompts", this.playPrompts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("interruptCallMediaOperation", this.interruptCallMediaOperation);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        return jsonWriter.writeEndObject();
    }

    public static RecognizeRequest fromJson(JsonReader jsonReader) throws IOException {
        return (RecognizeRequest)jsonReader.readObject(reader -> {
            RecognizeRequest deserializedRecognizeRequest = new RecognizeRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recognizeInputType".equals(fieldName)) {
                    deserializedRecognizeRequest.recognizeInputType = RecognizeInputTypeInternal.fromString(reader.getString());
                    continue;
                }
                if ("recognizeOptions".equals(fieldName)) {
                    deserializedRecognizeRequest.recognizeOptions = RecognizeOptionsInternal.fromJson(reader);
                    continue;
                }
                if ("playPrompt".equals(fieldName)) {
                    deserializedRecognizeRequest.playPrompt = PlaySourceInternal.fromJson(reader);
                    continue;
                }
                if ("playPrompts".equals(fieldName)) {
                    List playPrompts;
                    deserializedRecognizeRequest.playPrompts = playPrompts = reader.readArray(reader1 -> PlaySourceInternal.fromJson(reader1));
                    continue;
                }
                if ("interruptCallMediaOperation".equals(fieldName)) {
                    deserializedRecognizeRequest.interruptCallMediaOperation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("operationContext".equals(fieldName)) {
                    deserializedRecognizeRequest.operationContext = reader.getString();
                    continue;
                }
                if ("operationCallbackUri".equals(fieldName)) {
                    deserializedRecognizeRequest.operationCallbackUri = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecognizeRequest;
        });
    }
}

