/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.implementation.models.CustomCallingContext;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class IncomingCall
implements JsonSerializable<IncomingCall> {
    private CommunicationIdentifierModel to;
    private CommunicationIdentifierModel from;
    private String callerDisplayName;
    private String serverCallId;
    private CustomCallingContext customContext;
    private String incomingCallContext;
    private CommunicationIdentifierModel onBehalfOfCallee;
    private String correlationId;

    public CommunicationIdentifierModel getTo() {
        return this.to;
    }

    public CommunicationIdentifierModel getFrom() {
        return this.from;
    }

    public String getCallerDisplayName() {
        return this.callerDisplayName;
    }

    public String getServerCallId() {
        return this.serverCallId;
    }

    public CustomCallingContext getCustomContext() {
        return this.customContext;
    }

    public String getIncomingCallContext() {
        return this.incomingCallContext;
    }

    public CommunicationIdentifierModel getOnBehalfOfCallee() {
        return this.onBehalfOfCallee;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static IncomingCall fromJson(JsonReader jsonReader) throws IOException {
        return (IncomingCall)jsonReader.readObject(reader -> {
            IncomingCall deserializedIncomingCall = new IncomingCall();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("to".equals(fieldName)) {
                    deserializedIncomingCall.to = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("from".equals(fieldName)) {
                    deserializedIncomingCall.from = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("callerDisplayName".equals(fieldName)) {
                    deserializedIncomingCall.callerDisplayName = reader.getString();
                    continue;
                }
                if ("serverCallId".equals(fieldName)) {
                    deserializedIncomingCall.serverCallId = reader.getString();
                    continue;
                }
                if ("customContext".equals(fieldName)) {
                    deserializedIncomingCall.customContext = CustomCallingContext.fromJson(reader);
                    continue;
                }
                if ("incomingCallContext".equals(fieldName)) {
                    deserializedIncomingCall.incomingCallContext = reader.getString();
                    continue;
                }
                if ("onBehalfOfCallee".equals(fieldName)) {
                    deserializedIncomingCall.onBehalfOfCallee = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedIncomingCall.correlationId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIncomingCall;
        });
    }
}

