/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.logging.ClientLogger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CustomHmacAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(CustomHmacAuthenticationPolicy.class);
    private static final HttpHeaderName X_FORWARDED_HOST = HttpHeaderName.fromString((String)"X-FORWARDED-HOST");
    private static final HttpHeaderName X_MS_DATE_HEADER = HttpHeaderName.fromString((String)"x-ms-date");
    private static final HttpHeaderName X_MS_STRING_TO_SIGN_HEADER = HttpHeaderName.fromString((String)"x-ms-hmac-string-to-sign-base64");
    private static final HttpHeaderName CONTENT_HASH_HEADER = HttpHeaderName.fromString((String)"x-ms-content-sha256");
    static final DateTimeFormatter HMAC_DATETIMEFORMATTER_PATTERN = DateTimeFormatter.ofPattern("E, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    private final AzureKeyCredential credential;
    private final String acsResource;

    public CustomHmacAuthenticationPolicy(AzureKeyCredential clientCredential, String acsResource) {
        Objects.requireNonNull(clientCredential, "'clientCredential' cannot be a null value.");
        this.credential = clientCredential;
        this.acsResource = acsResource;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        Flux contents;
        Flux flux = contents = context.getHttpRequest().getBody() == null ? Flux.just((Object)ByteBuffer.allocate(0)) : context.getHttpRequest().getBody();
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error((Throwable)new RuntimeException("AzureKeyCredential requires a URL using the HTTPS protocol scheme"));
        }
        try {
            URL hostnameToSignWith = context.getData("hmacSignatureURL").filter(alternativeUrl -> alternativeUrl instanceof URL).map(alternativeUrl -> (URL)alternativeUrl).orElse(context.getHttpRequest().getUrl());
            return contents.collect(() -> {
                try {
                    return MessageDigest.getInstance("SHA-256");
                }
                catch (NoSuchAlgorithmException e) {
                    throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
                }
            }, MessageDigest::update).flatMap(messageDigest -> {
                this.addAuthenticationHeaders(this.acsResource, hostnameToSignWith, context.getHttpRequest().getHttpMethod().toString(), (MessageDigest)messageDigest, context.getHttpRequest().getHeaders());
                return next.process();
            });
        }
        catch (RuntimeException r) {
            return Mono.error((Throwable)r);
        }
    }

    private void addAuthenticationHeaders(String acsResource, URL url, String httpMethod, MessageDigest messageDigest, HttpHeaders headers) {
        String contentHash = Base64.getEncoder().encodeToString(messageDigest.digest());
        headers.set(X_FORWARDED_HOST, acsResource);
        headers.set(HttpHeaderName.HOST, acsResource);
        headers.set(CONTENT_HASH_HEADER, contentHash);
        String xMsDate = OffsetDateTime.now(ZoneOffset.UTC).format(HMAC_DATETIMEFORMATTER_PATTERN);
        headers.set(X_MS_DATE_HEADER, xMsDate);
        this.addSignatureHeader(url, httpMethod, headers, xMsDate, acsResource, contentHash);
    }

    private void addSignatureHeader(URL url, String httpMethod, HttpHeaders headers, String xMsDate, String host, String xMsContentSha256) {
        Mac sha256HMAC;
        String signedHeaderValues = xMsDate + ";" + host + ";" + xMsContentSha256;
        String pathAndQuery = url.getPath();
        if (url.getQuery() != null) {
            pathAndQuery = pathAndQuery + '?' + url.getQuery();
        }
        String stringToSign = httpMethod.toUpperCase(Locale.US) + "\n" + pathAndQuery + "\n" + signedHeaderValues;
        String accessKey = this.credential.getKey();
        byte[] key = Base64.getDecoder().decode(accessKey);
        try {
            sha256HMAC = Mac.getInstance("HmacSHA256");
            sha256HMAC.init(new SecretKeySpec(key, "HmacSHA256"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        String signature = Base64.getEncoder().encodeToString(sha256HMAC.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8)));
        String authorization = "HMAC-SHA256 SignedHeaders=x-ms-date;host;x-ms-content-sha256&Signature=" + signature;
        headers.set(HttpHeaderName.AUTHORIZATION, authorization);
        headers.set(X_MS_STRING_TO_SIGN_HEADER, Base64.getEncoder().encodeToString(stringToSign.getBytes(StandardCharsets.UTF_8)));
    }
}

