/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.CallAutomationClientBuilder;
import com.azure.communication.callautomation.CallConnection;
import com.azure.communication.callautomation.CallConnectionAsync;
import com.azure.communication.callautomation.CallRecordingAsync;
import com.azure.communication.callautomation.ContentDownloader;
import com.azure.communication.callautomation.implementation.AzureCommunicationCallAutomationServiceImpl;
import com.azure.communication.callautomation.implementation.CallConnectionsImpl;
import com.azure.communication.callautomation.implementation.CallMediasImpl;
import com.azure.communication.callautomation.implementation.CallRecordingsImpl;
import com.azure.communication.callautomation.implementation.accesshelpers.CallConnectionPropertiesConstructorProxy;
import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.converters.CommunicationUserIdentifierConverter;
import com.azure.communication.callautomation.implementation.converters.MicrosoftTeamsAppIdentifierConverter;
import com.azure.communication.callautomation.implementation.converters.PhoneNumberIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.AnswerCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.AudioFormatInternal;
import com.azure.communication.callautomation.implementation.models.CallConnectionPropertiesInternal;
import com.azure.communication.callautomation.implementation.models.CallIntelligenceOptionsInternal;
import com.azure.communication.callautomation.implementation.models.CallLocatorInternal;
import com.azure.communication.callautomation.implementation.models.CallLocatorKindInternal;
import com.azure.communication.callautomation.implementation.models.CallRejectReasonInternal;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.implementation.models.CommunicationUserIdentifierModel;
import com.azure.communication.callautomation.implementation.models.ConnectRequestInternal;
import com.azure.communication.callautomation.implementation.models.CreateCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.MediaStreamingAudioChannelTypeInternal;
import com.azure.communication.callautomation.implementation.models.MediaStreamingContentTypeInternal;
import com.azure.communication.callautomation.implementation.models.MediaStreamingOptionsInternal;
import com.azure.communication.callautomation.implementation.models.RedirectCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.RejectCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.TranscriptionOptionsInternal;
import com.azure.communication.callautomation.implementation.models.WebSocketMediaStreamingOptionsInternal;
import com.azure.communication.callautomation.implementation.models.WebSocketTranscriptionOptionsInternal;
import com.azure.communication.callautomation.models.AnswerCallOptions;
import com.azure.communication.callautomation.models.AnswerCallResult;
import com.azure.communication.callautomation.models.CallInvite;
import com.azure.communication.callautomation.models.CallLocator;
import com.azure.communication.callautomation.models.CallLocatorKind;
import com.azure.communication.callautomation.models.ConnectCallOptions;
import com.azure.communication.callautomation.models.ConnectCallResult;
import com.azure.communication.callautomation.models.CreateCallOptions;
import com.azure.communication.callautomation.models.CreateCallResult;
import com.azure.communication.callautomation.models.CreateGroupCallOptions;
import com.azure.communication.callautomation.models.GroupCallLocator;
import com.azure.communication.callautomation.models.MediaStreamingOptions;
import com.azure.communication.callautomation.models.RedirectCallOptions;
import com.azure.communication.callautomation.models.RejectCallOptions;
import com.azure.communication.callautomation.models.RoomCallLocator;
import com.azure.communication.callautomation.models.ServerCallLocator;
import com.azure.communication.callautomation.models.TranscriptionOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CallAutomationClientBuilder.class, isAsync=true)
public final class CallAutomationAsyncClient {
    private final CallConnectionsImpl callConnectionsInternal;
    private final AzureCommunicationCallAutomationServiceImpl azureCommunicationCallAutomationServiceInternal;
    private final CallRecordingsImpl callRecordingsInternal;
    private final CallMediasImpl callMediasInternal;
    private final ClientLogger logger;
    private final ContentDownloader contentDownloader;
    private final HttpPipeline httpPipelineInternal;
    private final String resourceUrl;
    private final CommunicationUserIdentifierModel sourceIdentity;

    CallAutomationAsyncClient(AzureCommunicationCallAutomationServiceImpl callServiceClient, CommunicationUserIdentifier sourceIdentity) {
        this.callConnectionsInternal = callServiceClient.getCallConnections();
        this.azureCommunicationCallAutomationServiceInternal = callServiceClient;
        this.callRecordingsInternal = callServiceClient.getCallRecordings();
        this.callMediasInternal = callServiceClient.getCallMedias();
        this.logger = new ClientLogger(CallAutomationAsyncClient.class);
        this.contentDownloader = new ContentDownloader(callServiceClient.getEndpoint(), callServiceClient.getHttpPipeline());
        this.httpPipelineInternal = callServiceClient.getHttpPipeline();
        this.resourceUrl = callServiceClient.getEndpoint();
        this.sourceIdentity = sourceIdentity == null ? null : CommunicationUserIdentifierConverter.convert(sourceIdentity);
    }

    public CommunicationUserIdentifier getSourceIdentity() {
        return this.sourceIdentity == null ? null : CommunicationUserIdentifierConverter.convert(this.sourceIdentity);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateCallResult> createCall(CallInvite targetParticipant, String callbackUrl) {
        CreateCallOptions createCallOptions = new CreateCallOptions(targetParticipant, callbackUrl);
        return this.createCallWithResponse(createCallOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateCallResult> createGroupCall(List<CommunicationIdentifier> targetParticipants, String callbackUrl) {
        CreateGroupCallOptions createGroupCallOptions = new CreateGroupCallOptions(targetParticipants, callbackUrl);
        return this.createGroupCallWithResponse(createGroupCallOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateCallResult>> createCallWithResponse(CreateCallOptions createCallOptions) {
        return FluxUtil.withContext(context -> this.createCallWithResponseInternal(createCallOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateCallResult>> createGroupCallWithResponse(CreateGroupCallOptions createGroupCallOptions) {
        return FluxUtil.withContext(context -> this.createGroupCallWithResponseInternal(createGroupCallOptions, (Context)context));
    }

    Mono<Response<CreateCallResult>> createCallWithResponseInternal(CreateCallOptions createCallOptions, Context context) {
        return this.getCreateCallResponseMono(context, this.getCreateCallRequestInternal(createCallOptions));
    }

    Mono<Response<CreateCallResult>> createGroupCallWithResponseInternal(CreateGroupCallOptions createGroupCallOptions, Context context) {
        return this.getCreateCallResponseMono(context, this.getCreateCallRequestInternal(createGroupCallOptions));
    }

    private Mono<Response<CreateCallResult>> getCreateCallResponseMono(Context context, CreateCallRequestInternal createCallRequestInternal) {
        try {
            context = context == null ? Context.NONE : context;
            return this.azureCommunicationCallAutomationServiceInternal.createCallWithResponseAsync(createCallRequestInternal, context).map(response -> {
                try {
                    CallConnectionAsync callConnectionAsync = this.getCallConnectionAsync(((CallConnectionPropertiesInternal)response.getValue()).getCallConnectionId());
                    return new SimpleResponse(response, (Object)new CreateCallResult(CallConnectionPropertiesConstructorProxy.create((CallConnectionPropertiesInternal)response.getValue()), new CallConnection(callConnectionAsync), callConnectionAsync));
                }
                catch (URISyntaxException e) {
                    throw this.logger.logExceptionAsError(new RuntimeException(e));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private CreateCallRequestInternal getCreateCallRequestInternal(CreateCallOptions createCallOptions) {
        LinkedList<CommunicationIdentifierModel> targetsModel = new LinkedList<CommunicationIdentifierModel>();
        targetsModel.add(CommunicationIdentifierConverter.convert(createCallOptions.getCallInvite().getTargetParticipant()));
        CallIntelligenceOptionsInternal callIntelligenceOptionsInternal = null;
        if (createCallOptions.getCallIntelligenceOptions() != null && createCallOptions.getCallIntelligenceOptions().getCognitiveServicesEndpoint() != null) {
            callIntelligenceOptionsInternal = new CallIntelligenceOptionsInternal();
            callIntelligenceOptionsInternal.setCognitiveServicesEndpoint(createCallOptions.getCallIntelligenceOptions().getCognitiveServicesEndpoint());
        }
        CreateCallRequestInternal request = new CreateCallRequestInternal().setSourceCallerIdNumber(PhoneNumberIdentifierConverter.convert(createCallOptions.getCallInvite().getSourceCallerIdNumber())).setSourceDisplayName(createCallOptions.getCallInvite().getSourceDisplayName()).setSource(this.sourceIdentity).setTargets(targetsModel).setCallbackUri(createCallOptions.getCallbackUrl()).setCallIntelligenceOptions(callIntelligenceOptionsInternal).setOperationContext(createCallOptions.getOperationContext());
        if (createCallOptions.getMediaStreamingOptions() != null) {
            MediaStreamingOptionsInternal streamingOptionsInternal = this.getMediaStreamingOptionsInternal(createCallOptions.getMediaStreamingOptions());
            request.setMediaStreamingOptions(streamingOptionsInternal);
        }
        if (createCallOptions.getTranscriptionOptions() != null) {
            TranscriptionOptionsInternal transcriptionOptionsInternal = this.getTranscriptionOptionsInternal(createCallOptions.getTranscriptionOptions());
            request.setTranscriptionOptions(transcriptionOptionsInternal);
        }
        if (createCallOptions.getTeamsAppSource() != null) {
            request.setTeamsAppSource(MicrosoftTeamsAppIdentifierConverter.convert(createCallOptions.getTeamsAppSource()));
        }
        return request;
    }

    private CreateCallRequestInternal getCreateCallRequestInternal(CreateGroupCallOptions createCallGroupOptions) {
        List<CommunicationIdentifierModel> targetsModel = createCallGroupOptions.getTargetParticipants().stream().map(CommunicationIdentifierConverter::convert).collect(Collectors.toList());
        CallIntelligenceOptionsInternal callIntelligenceOptionsInternal = null;
        if (createCallGroupOptions.getCallIntelligenceOptions() != null && createCallGroupOptions.getCallIntelligenceOptions().getCognitiveServicesEndpoint() != null) {
            callIntelligenceOptionsInternal = new CallIntelligenceOptionsInternal();
            callIntelligenceOptionsInternal.setCognitiveServicesEndpoint(createCallGroupOptions.getCallIntelligenceOptions().getCognitiveServicesEndpoint());
        }
        CreateCallRequestInternal request = new CreateCallRequestInternal().setSourceCallerIdNumber(PhoneNumberIdentifierConverter.convert(createCallGroupOptions.getSourceCallIdNumber())).setSourceDisplayName(createCallGroupOptions.getSourceDisplayName()).setSource(this.sourceIdentity).setTargets(targetsModel).setCallbackUri(createCallGroupOptions.getCallbackUrl()).setCallIntelligenceOptions(callIntelligenceOptionsInternal).setOperationContext(createCallGroupOptions.getOperationContext());
        if (createCallGroupOptions.getMediaStreamingOptions() != null) {
            MediaStreamingOptionsInternal streamingOptionsInternal = this.getMediaStreamingOptionsInternal(createCallGroupOptions.getMediaStreamingOptions());
            request.setMediaStreamingOptions(streamingOptionsInternal);
        }
        if (createCallGroupOptions.getTranscriptionOptions() != null) {
            TranscriptionOptionsInternal transcriptionOptionsInternal = this.getTranscriptionOptionsInternal(createCallGroupOptions.getTranscriptionOptions());
            request.setTranscriptionOptions(transcriptionOptionsInternal);
        }
        if (createCallGroupOptions.getTeamsAppSource() != null) {
            request.setTeamsAppSource(MicrosoftTeamsAppIdentifierConverter.convert(createCallGroupOptions.getTeamsAppSource()));
        }
        return request;
    }

    private MediaStreamingOptionsInternal getMediaStreamingOptionsInternal(MediaStreamingOptions mediaStreamingOptions) {
        return new WebSocketMediaStreamingOptionsInternal().setTransportUrl(mediaStreamingOptions.getTransportUrl()).setAudioChannelType(MediaStreamingAudioChannelTypeInternal.fromString(mediaStreamingOptions.getAudioChannelType().toString())).setContentType(MediaStreamingContentTypeInternal.fromString(mediaStreamingOptions.getContentType().toString())).setStartMediaStreaming(mediaStreamingOptions.isStartMediaStreamingEnabled()).setEnableBidirectional(mediaStreamingOptions.isEnableBidirectional()).setAudioFormat(AudioFormatInternal.fromString(mediaStreamingOptions.getAudioFormat() != null ? mediaStreamingOptions.getAudioFormat().toString() : null)).setEnableDtmfTones(mediaStreamingOptions.isEnableDtmfTones());
    }

    private TranscriptionOptionsInternal getTranscriptionOptionsInternal(TranscriptionOptions transcriptionOptions) {
        return new WebSocketTranscriptionOptionsInternal().setTransportUrl(transcriptionOptions.getTransportUrl()).setLocale(transcriptionOptions.getLocale()).setStartTranscription(transcriptionOptions.isStartTranscription()).setEnableIntermediateResults(transcriptionOptions.isIntermediateResultsEnabled()).setSpeechModelEndpointId(transcriptionOptions.getSpeechRecognitionModelEndpointId());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnswerCallResult> answerCall(String incomingCallContext, String callbackUrl) {
        return this.answerCallWithResponse(new AnswerCallOptions(incomingCallContext, callbackUrl)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnswerCallResult>> answerCallWithResponse(AnswerCallOptions answerCallOptions) {
        return FluxUtil.withContext(context -> this.answerCallWithResponseInternal(answerCallOptions, (Context)context));
    }

    Mono<Response<AnswerCallResult>> answerCallWithResponseInternal(AnswerCallOptions answerCallOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            AnswerCallRequestInternal request = new AnswerCallRequestInternal().setIncomingCallContext(answerCallOptions.getIncomingCallContext()).setCallbackUri(answerCallOptions.getCallbackUrl()).setAnsweredBy(this.sourceIdentity).setOperationContext(answerCallOptions.getOperationContext());
            if (answerCallOptions.getCallIntelligenceOptions() != null && answerCallOptions.getCallIntelligenceOptions().getCognitiveServicesEndpoint() != null) {
                CallIntelligenceOptionsInternal callIntelligenceOptionsInternal = new CallIntelligenceOptionsInternal();
                callIntelligenceOptionsInternal.setCognitiveServicesEndpoint(answerCallOptions.getCallIntelligenceOptions().getCognitiveServicesEndpoint());
                request.setCallIntelligenceOptions(callIntelligenceOptionsInternal);
            }
            if (answerCallOptions.getMediaStreamingOptions() != null) {
                MediaStreamingOptionsInternal streamingOptionsInternal = this.getMediaStreamingOptionsInternal(answerCallOptions.getMediaStreamingOptions());
                request.setMediaStreamingOptions(streamingOptionsInternal);
            }
            if (answerCallOptions.getTranscriptionOptions() != null) {
                TranscriptionOptionsInternal transcriptionOptionsInternal = this.getTranscriptionOptionsInternal(answerCallOptions.getTranscriptionOptions());
                request.setTranscriptionOptions(transcriptionOptionsInternal);
            }
            return this.azureCommunicationCallAutomationServiceInternal.answerCallWithResponseAsync(request, context).map(response -> {
                try {
                    CallConnectionAsync callConnectionAsync = this.getCallConnectionAsync(((CallConnectionPropertiesInternal)response.getValue()).getCallConnectionId());
                    return new SimpleResponse(response, (Object)new AnswerCallResult(CallConnectionPropertiesConstructorProxy.create((CallConnectionPropertiesInternal)response.getValue()), new CallConnection(callConnectionAsync), callConnectionAsync));
                }
                catch (URISyntaxException e) {
                    throw this.logger.logExceptionAsError(new RuntimeException(e));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> redirectCall(String incomingCallContext, CallInvite targetParticipant) {
        RedirectCallOptions redirectCallOptions = new RedirectCallOptions(incomingCallContext, targetParticipant);
        return this.redirectCallWithResponse(redirectCallOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> redirectCallWithResponse(RedirectCallOptions redirectCallOptions) {
        return FluxUtil.withContext(context -> this.redirectCallWithResponseInternal(redirectCallOptions, (Context)context));
    }

    Mono<Response<Void>> redirectCallWithResponseInternal(RedirectCallOptions redirectCallOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            RedirectCallRequestInternal request = new RedirectCallRequestInternal().setIncomingCallContext(redirectCallOptions.getIncomingCallContext()).setTarget(CommunicationIdentifierConverter.convert(redirectCallOptions.getTargetParticipant().getTargetParticipant()));
            return this.azureCommunicationCallAutomationServiceInternal.redirectCallWithResponseAsync(request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rejectCall(String incomingCallContext) {
        RejectCallOptions rejectCallOptions = new RejectCallOptions(incomingCallContext);
        return this.rejectCallWithResponse(rejectCallOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rejectCallWithResponse(RejectCallOptions rejectCallOptions) {
        return FluxUtil.withContext(context -> this.rejectCallWithResponseInternal(rejectCallOptions, (Context)context));
    }

    Mono<Response<Void>> rejectCallWithResponseInternal(RejectCallOptions rejectCallOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            RejectCallRequestInternal request = new RejectCallRequestInternal().setIncomingCallContext(rejectCallOptions.getIncomingCallContext());
            if (rejectCallOptions.getCallRejectReason() != null) {
                request.setCallRejectReason(CallRejectReasonInternal.fromString(rejectCallOptions.getCallRejectReason().toString()));
            }
            return this.azureCommunicationCallAutomationServiceInternal.rejectCallWithResponseAsync(request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectCallResult> connectCall(CallLocator callLocator, String callbackUrl) {
        return this.connectCallWithResponse(new ConnectCallOptions(callLocator, callbackUrl)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConnectCallResult>> connectCallWithResponse(ConnectCallOptions connectCallOptions) {
        return FluxUtil.withContext(context -> this.connectCallWithResponseInternal(connectCallOptions, (Context)context));
    }

    Mono<Response<ConnectCallResult>> connectCallWithResponseInternal(ConnectCallOptions connectCallOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            CallLocator callLocator = connectCallOptions.getCallLocator();
            CallLocatorInternal callLocatorInternal = new CallLocatorInternal().setKind(CallLocatorKindInternal.fromString(callLocator.getKind().toString()));
            if (callLocator.getKind() == CallLocatorKind.GROUP_CALL_LOCATOR) {
                callLocatorInternal.setGroupCallId(((GroupCallLocator)callLocator).getGroupCallId());
            } else if (callLocator.getKind() == CallLocatorKind.SERVER_CALL_LOCATOR) {
                callLocatorInternal.setServerCallId(((ServerCallLocator)callLocator).getServerCallId());
            } else if (callLocator.getKind() == CallLocatorKind.ROOM_CALL_LOCATOR) {
                callLocatorInternal.setRoomId(((RoomCallLocator)callLocator).getRoomId());
            } else {
                throw this.logger.logExceptionAsError((RuntimeException)new InvalidParameterException("callLocator has invalid kind."));
            }
            ConnectRequestInternal request = new ConnectRequestInternal().setCallbackUri(connectCallOptions.getCallbackUrl()).setCallLocator(callLocatorInternal);
            if (connectCallOptions.getOperationContext() != null) {
                request.setOperationContext(connectCallOptions.getOperationContext());
            }
            if (connectCallOptions.getCallIntelligenceOptions() != null && connectCallOptions.getCallIntelligenceOptions().getCognitiveServicesEndpoint() != null) {
                CallIntelligenceOptionsInternal callIntelligenceOptionsInternal = new CallIntelligenceOptionsInternal();
                callIntelligenceOptionsInternal.setCognitiveServicesEndpoint(connectCallOptions.getCallIntelligenceOptions().getCognitiveServicesEndpoint());
                request.setCallIntelligenceOptions(callIntelligenceOptionsInternal);
            }
            if (connectCallOptions.getMediaStreamingOptions() != null) {
                MediaStreamingOptionsInternal streamingOptionsInternal = this.getMediaStreamingOptionsInternal(connectCallOptions.getMediaStreamingOptions());
                request.setMediaStreamingOptions(streamingOptionsInternal);
            }
            if (connectCallOptions.getTranscriptionOptions() != null) {
                TranscriptionOptionsInternal transcriptionOptionsInternal = this.getTranscriptionOptionsInternal(connectCallOptions.getTranscriptionOptions());
                request.setTranscriptionOptions(transcriptionOptionsInternal);
            }
            return this.azureCommunicationCallAutomationServiceInternal.connectWithResponseAsync(request, context).map(response -> {
                try {
                    CallConnectionAsync callConnectionAsync = this.getCallConnectionAsync(((CallConnectionPropertiesInternal)response.getValue()).getCallConnectionId());
                    return new SimpleResponse(response, (Object)new ConnectCallResult(CallConnectionPropertiesConstructorProxy.create((CallConnectionPropertiesInternal)response.getValue()), new CallConnection(callConnectionAsync), callConnectionAsync));
                }
                catch (URISyntaxException e) {
                    throw this.logger.logExceptionAsError(new RuntimeException(e));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public CallConnectionAsync getCallConnectionAsync(String callConnectionId) {
        return new CallConnectionAsync(callConnectionId, this.callConnectionsInternal, this.callMediasInternal);
    }

    public CallRecordingAsync getCallRecordingAsync() {
        return new CallRecordingAsync(this.callRecordingsInternal, this.contentDownloader, this.httpPipelineInternal, this.resourceUrl);
    }
}

