/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.accesshelpers.TranscriptionSubscriptionConstructorProxy;
import com.azure.communication.callautomation.implementation.models.TranscriptionSubscriptionInternal;
import com.azure.communication.callautomation.models.TranscriptionResultState;
import com.azure.communication.callautomation.models.TranscriptionSubscriptionState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public final class TranscriptionSubscription
implements JsonSerializable<TranscriptionSubscription> {
    private String id;
    private TranscriptionSubscriptionState state;
    private String locale;
    private List<TranscriptionResultState> subscribedResultStates;

    TranscriptionSubscription() {
        this.id = null;
        this.state = null;
        this.subscribedResultStates = null;
        this.locale = null;
    }

    TranscriptionSubscription(TranscriptionSubscriptionInternal transcriptionSubscriptionInternal) {
        this.id = transcriptionSubscriptionInternal.getId() != null ? transcriptionSubscriptionInternal.getId() : null;
        this.state = transcriptionSubscriptionInternal.getState() != null ? TranscriptionSubscriptionState.fromString(transcriptionSubscriptionInternal.getState().toString()) : null;
        this.subscribedResultStates = transcriptionSubscriptionInternal.getSubscribedResultTypes() != null ? transcriptionSubscriptionInternal.getSubscribedResultTypes().stream().map(resultType -> TranscriptionResultState.fromString(resultType.toString())).collect(Collectors.toList()) : null;
        this.locale = transcriptionSubscriptionInternal.getLocale() != null ? transcriptionSubscriptionInternal.getLocale().toString() : null;
    }

    public String getId() {
        return this.id;
    }

    public TranscriptionSubscriptionState getState() {
        return this.state;
    }

    public String getLocale() {
        return this.locale;
    }

    public List<TranscriptionResultState> getSubscribedResultStates() {
        return this.subscribedResultStates;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("subscribedResultStates", this.subscribedResultStates, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("locale", this.locale);
        return jsonWriter.writeEndObject();
    }

    public static TranscriptionSubscription fromJson(JsonReader jsonReader) throws IOException {
        return (TranscriptionSubscription)jsonReader.readObject(reader -> {
            TranscriptionSubscription deserializedTranscriptionSubscription = new TranscriptionSubscription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTranscriptionSubscription.id = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedTranscriptionSubscription.state = TranscriptionSubscriptionState.fromString(reader.getString());
                    continue;
                }
                if ("subscribedResultStates".equals(fieldName)) {
                    List subscribedResultTypes;
                    deserializedTranscriptionSubscription.subscribedResultStates = subscribedResultTypes = reader.readArray(reader1 -> TranscriptionResultState.fromString(reader1.getString()));
                    continue;
                }
                if ("locale".equals(fieldName)) {
                    deserializedTranscriptionSubscription.locale = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTranscriptionSubscription;
        });
    }

    static {
        TranscriptionSubscriptionConstructorProxy.setAccessor(new TranscriptionSubscriptionConstructorProxy.TranscriptionSubscriptionConstructorAccessor(){

            @Override
            public TranscriptionSubscription create(TranscriptionSubscriptionInternal internalHeaders) {
                return new TranscriptionSubscription(internalHeaders);
            }
        });
    }
}

