/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.accesshelpers.AudioDataContructorProxy;
import com.azure.communication.callautomation.implementation.accesshelpers.AudioMetadataContructorProxy;
import com.azure.communication.callautomation.implementation.accesshelpers.DtmfDataContructorProxy;
import com.azure.communication.callautomation.implementation.accesshelpers.TranscriptionDataContructorProxy;
import com.azure.communication.callautomation.implementation.accesshelpers.TranscriptionMetadataContructorProxy;
import com.azure.communication.callautomation.implementation.converters.AudioDataConverter;
import com.azure.communication.callautomation.implementation.converters.AudioMetadataConverter;
import com.azure.communication.callautomation.implementation.converters.DtmfDataConverter;
import com.azure.communication.callautomation.implementation.converters.TranscriptionDataConverter;
import com.azure.communication.callautomation.implementation.converters.TranscriptionMetadataConverter;
import com.azure.communication.callautomation.models.AudioData;
import com.azure.communication.callautomation.models.AudioMetadata;
import com.azure.communication.callautomation.models.DtmfData;
import com.azure.communication.callautomation.models.StreamingDataKind;
import com.azure.communication.callautomation.models.TranscriptionData;
import com.azure.communication.callautomation.models.TranscriptionMetadata;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import java.io.IOException;

public abstract class StreamingData {
    private final StreamingDataKind streamingDataKind;

    public StreamingData(StreamingDataKind streamingDataKind) {
        this.streamingDataKind = streamingDataKind;
    }

    public StreamingDataKind getStreamingDataKind() {
        return this.streamingDataKind;
    }

    public static StreamingData parse(String data) {
        return StreamingData.parseStreamingData(data);
    }

    public static <T extends StreamingData> T parse(String data, Class<T> type) {
        return (T)StreamingData.parseStreamingData(data);
    }

    private static StreamingData parseStreamingData(String data) {
        StreamingData streamingData;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader((String)data);
            try {
                streamingData = (StreamingData)jsonReader.readObject(reader -> {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        switch (fieldName) {
                            case "audioData": {
                                AudioData audioData = AudioDataContructorProxy.create(AudioDataConverter.fromJson(jsonReader));
                                return audioData;
                            }
                            case "audioMetadata": {
                                AudioMetadata audioMetadata = AudioMetadataContructorProxy.create(AudioMetadataConverter.fromJson(jsonReader));
                                return audioMetadata;
                            }
                            case "dtmfData": {
                                DtmfData dtmfData = DtmfDataContructorProxy.create(DtmfDataConverter.fromJson(jsonReader));
                                return dtmfData;
                            }
                            case "transcriptionData": {
                                TranscriptionData transcriptionData = TranscriptionDataContructorProxy.create(TranscriptionDataConverter.fromJson(jsonReader));
                                return transcriptionData;
                            }
                            case "transcriptionMetadata": {
                                TranscriptionMetadata transcriptionMetadata = TranscriptionMetadataContructorProxy.create(TranscriptionMetadataConverter.fromJson(jsonReader));
                                return transcriptionMetadata;
                            }
                        }
                        reader.skipChildren();
                    }
                    return null;
                });
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse StreamingData", e);
                }
            }
            jsonReader.close();
        }
        return streamingData;
    }
}

