/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.core.util.ProgressListener;
import java.util.Locale;

public final class ParallelDownloadOptions {
    private static final String PARAMETER_NOT_IN_RANGE = "The value of the parameter '%s' should be between %s and %s.";
    private long blockSize = 0x400000L;
    private int maxConcurrency = 1;
    private ProgressListener progressListener;

    public Long getBlockSize() {
        return this.blockSize;
    }

    public ParallelDownloadOptions setBlockSize(long blockSize) {
        ParallelDownloadOptions.assertInBounds("blockSize", blockSize, 1L, Long.MAX_VALUE);
        this.blockSize = blockSize;
        return this;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public ParallelDownloadOptions setProgressReceiver(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public ParallelDownloadOptions setMaxConcurrency(int maxConcurrency) {
        ParallelDownloadOptions.assertInBounds("numBuffers", maxConcurrency, 1L, Integer.MAX_VALUE);
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    static void assertInBounds(String param, long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, PARAMETER_NOT_IN_RANGE, param, min, max));
        }
    }
}

