/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.models.CallMediaRecognizeOptions;
import com.azure.communication.callautomation.models.PlaySource;
import com.azure.communication.callautomation.models.RecognitionChoice;
import com.azure.communication.callautomation.models.RecognizeInputType;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class CallMediaRecognizeChoiceOptions
extends CallMediaRecognizeOptions {
    private final List<RecognitionChoice> choices;
    private String speechLanguage;
    private String speechRecognitionModelEndpointId;

    public List<RecognitionChoice> getChoices() {
        return this.choices;
    }

    public CallMediaRecognizeChoiceOptions setSpeechLanguage(String speechLanguage) {
        this.speechLanguage = speechLanguage;
        return this;
    }

    public String getSpeechLanguage() {
        return this.speechLanguage;
    }

    public String getSpeechRecognitionModelEndpointId() {
        return this.speechRecognitionModelEndpointId;
    }

    public CallMediaRecognizeChoiceOptions setSpeechRecognitionModelEndpointId(String speechRecognitionModelEndpointId) {
        this.speechRecognitionModelEndpointId = speechRecognitionModelEndpointId;
        return this;
    }

    @Override
    public CallMediaRecognizeChoiceOptions setRecognizeInputType(RecognizeInputType recognizeInputType) {
        super.setRecognizeInputType(recognizeInputType);
        return this;
    }

    @Override
    public CallMediaRecognizeChoiceOptions setPlayPrompt(PlaySource playPrompt) {
        super.setPlayPrompt(playPrompt);
        return this;
    }

    @Override
    public CallMediaRecognizeChoiceOptions setInterruptCallMediaOperation(Boolean interruptCallMediaOperation) {
        super.setInterruptCallMediaOperation(interruptCallMediaOperation);
        return this;
    }

    @Override
    public CallMediaRecognizeChoiceOptions setStopCurrentOperations(Boolean stopCurrentOperations) {
        super.setStopCurrentOperations(stopCurrentOperations);
        return this;
    }

    @Override
    public CallMediaRecognizeChoiceOptions setOperationContext(String operationContext) {
        super.setOperationContext(operationContext);
        return this;
    }

    @Override
    public CallMediaRecognizeChoiceOptions setInterruptPrompt(Boolean interruptPrompt) {
        super.setInterruptPrompt(interruptPrompt);
        return this;
    }

    @Override
    public CallMediaRecognizeChoiceOptions setInitialSilenceTimeout(Duration initialSilenceTimeout) {
        super.setInitialSilenceTimeout(initialSilenceTimeout);
        return this;
    }

    public CallMediaRecognizeChoiceOptions(CommunicationIdentifier targetParticipant, List<RecognitionChoice> choices) {
        super(RecognizeInputType.CHOICES, targetParticipant);
        this.choices = choices;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recognizeInputType", "choices");
        jsonWriter.writeJsonField("playPrompt", (JsonSerializable)this.getPlayPrompt());
        jsonWriter.writeArrayField("playPrompts", this.getPlayPrompts(), (writer, playPrompt) -> playPrompt.toJson(writer));
        jsonWriter.writeBooleanField("interruptCallMediaOperation", this.isInterruptCallMediaOperation());
        jsonWriter.writeBooleanField("stopCurrentOperations", this.isStopCurrentOperations());
        jsonWriter.writeStringField("operationContext", this.getOperationContext());
        jsonWriter.writeBooleanField("interruptPrompt", this.isInterruptPrompt());
        jsonWriter.writeStringField("initialSilenceTimeout", CoreUtils.durationToStringWithDays((Duration)this.getInitialSilenceTimeout()));
        jsonWriter.writeStringField("speechModelEndpointId", this.getSpeechRecognitionModelEndpointId());
        CommunicationIdentifierModel participant = CommunicationIdentifierConverter.convert(this.getTargetParticipant());
        jsonWriter.writeJsonField("targetParticipant", (JsonSerializable)participant);
        jsonWriter.writeStringField("operationCallbackUrl", this.getOperationCallbackUrl());
        jsonWriter.writeStringField("speechLanguage", this.speechLanguage);
        jsonWriter.writeStringField("speechRecognitionModelEndpointId", this.speechRecognitionModelEndpointId);
        jsonWriter.writeArrayField("choices", this.choices, (writer, choice) -> choice.toJson((JsonWriter)writer));
        return jsonWriter.writeEndObject();
    }

    public static CallMediaRecognizeChoiceOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CallMediaRecognizeChoiceOptions)jsonReader.readObject(reader -> {
            String speechLanguage = null;
            String speechRecognitionModelEndpointId = null;
            List choices = null;
            String recognizeInputType = null;
            Boolean interruptCallMediaOperation = null;
            Boolean stopCurrentOperations = null;
            String operationContext = null;
            Boolean interruptPrompt = null;
            Duration initialSilenceTimeout = null;
            String speechModelEndpointId = null;
            String operationCallbackUrl = null;
            CommunicationIdentifier targetParticipant = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("speechLanguage".equals(fieldName)) {
                    speechLanguage = reader.getString();
                    continue;
                }
                if ("speechRecognitionModelEndpointId".equals(fieldName)) {
                    speechRecognitionModelEndpointId = reader.getString();
                    continue;
                }
                if ("choices".equals(fieldName)) {
                    choices = reader.readArray(RecognitionChoice::fromJson);
                    continue;
                }
                if ("recognizeInputType".equals(fieldName)) {
                    recognizeInputType = reader.getString();
                    continue;
                }
                if ("interruptCallMediaOperation".equals(fieldName)) {
                    interruptCallMediaOperation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("stopCurrentOperations".equals(fieldName)) {
                    stopCurrentOperations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("operationContext".equals(fieldName)) {
                    operationContext = reader.getString();
                    continue;
                }
                if ("interruptPrompt".equals(fieldName)) {
                    interruptPrompt = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("initialSilenceTimeout".equals(fieldName)) {
                    String value = reader.getString();
                    initialSilenceTimeout = value != null ? Duration.parse(value) : null;
                    continue;
                }
                if ("speechModelEndpointId".equals(fieldName)) {
                    speechModelEndpointId = reader.getString();
                    continue;
                }
                if ("operationCallbackUrl".equals(fieldName)) {
                    operationCallbackUrl = reader.getString();
                    continue;
                }
                if ("targetParticipant".equals(fieldName)) {
                    CommunicationIdentifierModel inner = CommunicationIdentifierModel.fromJson(reader);
                    targetParticipant = CommunicationIdentifierConverter.convert(inner);
                    continue;
                }
                reader.skipChildren();
            }
            CallMediaRecognizeChoiceOptions options = new CallMediaRecognizeChoiceOptions(targetParticipant, choices);
            options.speechLanguage = speechLanguage;
            options.speechRecognitionModelEndpointId = speechRecognitionModelEndpointId;
            options.setRecognizeInputType(RecognizeInputType.fromString(recognizeInputType));
            options.setInterruptCallMediaOperation(interruptCallMediaOperation);
            options.setStopCurrentOperations(stopCurrentOperations);
            options.setOperationContext(operationContext);
            options.setInterruptPrompt(interruptPrompt);
            options.setInitialSilenceTimeout(initialSilenceTimeout);
            options.setSpeechRecognitionModelEndpointId(speechModelEndpointId);
            options.setOperationCallbackUrl(operationCallbackUrl);
            return options;
        });
    }
}

