/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.MediaStreamingContentTypeInternal;
import com.azure.communication.callautomation.implementation.models.MediaStreamingSubscriptionState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MediaStreamingSubscription
implements JsonSerializable<MediaStreamingSubscription> {
    private String id;
    private MediaStreamingSubscriptionState state;
    private List<MediaStreamingContentTypeInternal> subscribedContentTypes;

    public String getId() {
        return this.id;
    }

    public MediaStreamingSubscription setId(String id) {
        this.id = id;
        return this;
    }

    public MediaStreamingSubscriptionState getState() {
        return this.state;
    }

    public MediaStreamingSubscription setState(MediaStreamingSubscriptionState state) {
        this.state = state;
        return this;
    }

    public List<MediaStreamingContentTypeInternal> getSubscribedContentTypes() {
        return this.subscribedContentTypes;
    }

    public MediaStreamingSubscription setSubscribedContentTypes(List<MediaStreamingContentTypeInternal> subscribedContentTypes) {
        this.subscribedContentTypes = subscribedContentTypes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("subscribedContentTypes", this.subscribedContentTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static MediaStreamingSubscription fromJson(JsonReader jsonReader) throws IOException {
        return (MediaStreamingSubscription)jsonReader.readObject(reader -> {
            MediaStreamingSubscription deserializedMediaStreamingSubscription = new MediaStreamingSubscription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMediaStreamingSubscription.id = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMediaStreamingSubscription.state = MediaStreamingSubscriptionState.fromString(reader.getString());
                    continue;
                }
                if ("subscribedContentTypes".equals(fieldName)) {
                    List subscribedContentTypes;
                    deserializedMediaStreamingSubscription.subscribedContentTypes = subscribedContentTypes = reader.readArray(reader1 -> MediaStreamingContentTypeInternal.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaStreamingSubscription;
        });
    }
}

