/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class CustomBearerTokenAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(CustomBearerTokenAuthenticationPolicy.class);
    private static final String BEARER = "Bearer";
    private static final HttpHeaderName X_FORWARDED_HOST = HttpHeaderName.fromString((String)"X-FORWARDED-HOST");
    private final String[] scopes;
    private final String acsEndpoint;
    private final TokenCredential tokenCredential;

    public CustomBearerTokenAuthenticationPolicy(TokenCredential credential, String acsEndpoint, String ... scopes) {
        Objects.requireNonNull(credential);
        this.scopes = scopes;
        this.acsEndpoint = acsEndpoint;
        this.tokenCredential = credential;
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        if (this.scopes == null) {
            return Mono.empty();
        }
        return this.setAuthorizationHeaderHelper(context, new TokenRequestContext().addScopes(this.scopes), false);
    }

    public void authorizeRequestSync(HttpPipelineCallContext context) {
        this.setAuthorizationHeaderHelperSync(context, new TokenRequestContext().addScopes(this.scopes), false);
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        return Mono.just((Object)false);
    }

    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext context, HttpResponse response) {
        return false;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error((Throwable)new RuntimeException("token credentials require a URL using the HTTPS protocol scheme"));
        }
        this.addHeaders(context.getHttpRequest().getHeaders());
        HttpPipelineNextPolicy nextPolicy = next.clone();
        return this.authorizeRequest(context).then(Mono.defer(() -> ((HttpPipelineNextPolicy)next).process())).flatMap(httpResponse -> {
            String authHeader = httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
            if (httpResponse.getStatusCode() == 401 && authHeader != null) {
                return this.authorizeRequestOnChallenge(context, (HttpResponse)httpResponse).flatMap(retry -> {
                    if (retry.booleanValue()) {
                        return httpResponse.getBody().ignoreElements().then(nextPolicy.process());
                    }
                    return Mono.just((Object)httpResponse);
                });
            }
            return Mono.just((Object)httpResponse);
        });
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            throw LOGGER.logExceptionAsError(new RuntimeException("token credentials require a URL using the HTTPS protocol scheme"));
        }
        this.addHeaders(context.getHttpRequest().getHeaders());
        HttpPipelineNextSyncPolicy nextPolicy = next.clone();
        this.authorizeRequestSync(context);
        HttpResponse httpResponse = next.processSync();
        String authHeader = httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        if (httpResponse.getStatusCode() == 401 && authHeader != null) {
            if (this.authorizeRequestOnChallengeSync(context, httpResponse)) {
                return nextPolicy.processSync();
            }
            return httpResponse;
        }
        return httpResponse;
    }

    public Mono<Void> setAuthorizationHeader(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext) {
        return this.setAuthorizationHeaderHelper(context, tokenRequestContext, true);
    }

    public void setAuthorizationHeaderSync(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext) {
        this.setAuthorizationHeaderHelperSync(context, tokenRequestContext, true);
    }

    private Mono<Void> setAuthorizationHeaderHelper(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext, boolean checkToForceFetchToken) {
        return this.tokenCredential.getToken(tokenRequestContext).flatMap(token1 -> {
            CustomBearerTokenAuthenticationPolicy.setAuthorizationHeader(context.getHttpRequest().getHeaders(), token1.getToken());
            return Mono.empty();
        });
    }

    private void setAuthorizationHeaderHelperSync(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext, boolean checkToForceFetchToken) {
        AccessToken token = this.tokenCredential.getTokenSync(tokenRequestContext);
        CustomBearerTokenAuthenticationPolicy.setAuthorizationHeader(context.getHttpRequest().getHeaders(), token.getToken());
    }

    private static void setAuthorizationHeader(HttpHeaders headers, String token) {
        headers.set(HttpHeaderName.AUTHORIZATION, "Bearer " + token);
    }

    private void addHeaders(HttpHeaders headers) {
        if (this.acsEndpoint != null) {
            headers.set(X_FORWARDED_HOST, this.acsEndpoint);
        }
    }
}

