/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation;

import com.azure.communication.callautomation.implementation.AzureCommunicationCallAutomationServiceImpl;
import com.azure.communication.callautomation.implementation.models.AddParticipantRequestInternal;
import com.azure.communication.callautomation.implementation.models.AddParticipantResponseInternal;
import com.azure.communication.callautomation.implementation.models.CallConnectionPropertiesInternal;
import com.azure.communication.callautomation.implementation.models.CallParticipantInternal;
import com.azure.communication.callautomation.implementation.models.CancelAddParticipantRequest;
import com.azure.communication.callautomation.implementation.models.CancelAddParticipantResponse;
import com.azure.communication.callautomation.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callautomation.implementation.models.GetParticipantsResponseInternal;
import com.azure.communication.callautomation.implementation.models.MuteParticipantsRequestInternal;
import com.azure.communication.callautomation.implementation.models.MuteParticipantsResultInternal;
import com.azure.communication.callautomation.implementation.models.RemoveParticipantRequestInternal;
import com.azure.communication.callautomation.implementation.models.RemoveParticipantResponseInternal;
import com.azure.communication.callautomation.implementation.models.TransferCallResponseInternal;
import com.azure.communication.callautomation.implementation.models.TransferToParticipantRequestInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class CallConnectionsImpl {
    private final CallConnectionsService service;
    private final AzureCommunicationCallAutomationServiceImpl client;

    CallConnectionsImpl(AzureCommunicationCallAutomationServiceImpl client) {
        this.service = (CallConnectionsService)RestProxy.create(CallConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> getCallWithResponseAsync(String callConnectionId) {
        return FluxUtil.withContext(context -> this.getCallWithResponseAsync(callConnectionId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> getCallWithResponseAsync(String callConnectionId, Context context) {
        String accept = "application/json";
        return this.service.getCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> getCallAsync(String callConnectionId) {
        return this.getCallWithResponseAsync(callConnectionId).flatMap(res -> Mono.justOrEmpty((Object)((CallConnectionPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> getCallAsync(String callConnectionId, Context context) {
        return this.getCallWithResponseAsync(callConnectionId, context).flatMap(res -> Mono.justOrEmpty((Object)((CallConnectionPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallConnectionPropertiesInternal> getCallWithResponse(String callConnectionId, Context context) {
        return (Response)this.getCallWithResponseAsync(callConnectionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallConnectionPropertiesInternal getCall(String callConnectionId) {
        return (CallConnectionPropertiesInternal)this.getCallWithResponse(callConnectionId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> hangupCallWithResponseAsync(String callConnectionId) {
        return FluxUtil.withContext(context -> this.hangupCallWithResponseAsync(callConnectionId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> hangupCallWithResponseAsync(String callConnectionId, Context context) {
        String accept = "application/json";
        return this.service.hangupCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hangupCallAsync(String callConnectionId) {
        return this.hangupCallWithResponseAsync(callConnectionId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hangupCallAsync(String callConnectionId, Context context) {
        return this.hangupCallWithResponseAsync(callConnectionId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> hangupCallWithResponse(String callConnectionId, Context context) {
        return (Response)this.hangupCallWithResponseAsync(callConnectionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void hangupCall(String callConnectionId) {
        this.hangupCallWithResponse(callConnectionId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateCallWithResponseAsync(String callConnectionId) {
        return FluxUtil.withContext(context -> this.terminateCallWithResponseAsync(callConnectionId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateCallWithResponseAsync(String callConnectionId, Context context) {
        String accept = "application/json";
        return this.service.terminateCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", CoreUtils.randomUuid().toString(), DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now()), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateCallAsync(String callConnectionId) {
        return this.terminateCallWithResponseAsync(callConnectionId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateCallAsync(String callConnectionId, Context context) {
        return this.terminateCallWithResponseAsync(callConnectionId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> terminateCallWithResponse(String callConnectionId, Context context) {
        return (Response)this.terminateCallWithResponseAsync(callConnectionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void terminateCall(String callConnectionId) {
        this.terminateCallWithResponse(callConnectionId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TransferCallResponseInternal>> transferToParticipantWithResponseAsync(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest) {
        return FluxUtil.withContext(context -> this.transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TransferCallResponseInternal>> transferToParticipantWithResponseAsync(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest, Context context) {
        String accept = "application/json";
        return this.service.transferToParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), transferToParticipantRequest, "application/json", CoreUtils.randomUuid().toString(), DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now()), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TransferCallResponseInternal> transferToParticipantAsync(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest) {
        return this.transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest).flatMap(res -> Mono.justOrEmpty((Object)((TransferCallResponseInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TransferCallResponseInternal> transferToParticipantAsync(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest, Context context) {
        return this.transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((TransferCallResponseInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TransferCallResponseInternal> transferToParticipantWithResponse(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest, Context context) {
        return (Response)this.transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TransferCallResponseInternal transferToParticipant(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest) {
        return (TransferCallResponseInternal)this.transferToParticipantWithResponse(callConnectionId, transferToParticipantRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsSinglePageAsync(String callConnectionId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getParticipants(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetParticipantsResponseInternal)res.getValue()).getValue(), ((GetParticipantsResponseInternal)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsSinglePageAsync(String callConnectionId, Context context) {
        String accept = "application/json";
        return this.service.getParticipants(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetParticipantsResponseInternal)res.getValue()).getValue(), ((GetParticipantsResponseInternal)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CallParticipantInternal> getParticipantsAsync(String callConnectionId) {
        return new PagedFlux(() -> this.getParticipantsSinglePageAsync(callConnectionId), nextLink -> this.getParticipantsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CallParticipantInternal> getParticipantsAsync(String callConnectionId, Context context) {
        return new PagedFlux(() -> this.getParticipantsSinglePageAsync(callConnectionId, context), nextLink -> this.getParticipantsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CallParticipantInternal> getParticipantsSinglePage(String callConnectionId) {
        return (PagedResponse)this.getParticipantsSinglePageAsync(callConnectionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CallParticipantInternal> getParticipantsSinglePage(String callConnectionId, Context context) {
        return (PagedResponse)this.getParticipantsSinglePageAsync(callConnectionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CallParticipantInternal> getParticipants(String callConnectionId) {
        return new PagedIterable(this.getParticipantsAsync(callConnectionId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CallParticipantInternal> getParticipants(String callConnectionId, Context context) {
        return new PagedIterable(this.getParticipantsAsync(callConnectionId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResponseInternal>> addParticipantWithResponseAsync(String callConnectionId, AddParticipantRequestInternal addParticipantRequest) {
        return FluxUtil.withContext(context -> this.addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResponseInternal>> addParticipantWithResponseAsync(String callConnectionId, AddParticipantRequestInternal addParticipantRequest, Context context) {
        String accept = "application/json";
        return this.service.addParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), addParticipantRequest, "application/json", CoreUtils.randomUuid().toString(), DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now()), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResponseInternal> addParticipantAsync(String callConnectionId, AddParticipantRequestInternal addParticipantRequest) {
        return this.addParticipantWithResponseAsync(callConnectionId, addParticipantRequest).flatMap(res -> Mono.justOrEmpty((Object)((AddParticipantResponseInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResponseInternal> addParticipantAsync(String callConnectionId, AddParticipantRequestInternal addParticipantRequest, Context context) {
        return this.addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((AddParticipantResponseInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddParticipantResponseInternal> addParticipantWithResponse(String callConnectionId, AddParticipantRequestInternal addParticipantRequest, Context context) {
        return (Response)this.addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddParticipantResponseInternal addParticipant(String callConnectionId, AddParticipantRequestInternal addParticipantRequest) {
        return (AddParticipantResponseInternal)this.addParticipantWithResponse(callConnectionId, addParticipantRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RemoveParticipantResponseInternal>> removeParticipantWithResponseAsync(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest) {
        return FluxUtil.withContext(context -> this.removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RemoveParticipantResponseInternal>> removeParticipantWithResponseAsync(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest, Context context) {
        String accept = "application/json";
        return this.service.removeParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), removeParticipantRequest, "application/json", CoreUtils.randomUuid().toString(), DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now()), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoveParticipantResponseInternal> removeParticipantAsync(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest) {
        return this.removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest).flatMap(res -> Mono.justOrEmpty((Object)((RemoveParticipantResponseInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoveParticipantResponseInternal> removeParticipantAsync(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest, Context context) {
        return this.removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((RemoveParticipantResponseInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemoveParticipantResponseInternal> removeParticipantWithResponse(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest, Context context) {
        return (Response)this.removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemoveParticipantResponseInternal removeParticipant(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest) {
        return (RemoveParticipantResponseInternal)this.removeParticipantWithResponse(callConnectionId, removeParticipantRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MuteParticipantsResultInternal>> muteWithResponseAsync(String callConnectionId, MuteParticipantsRequestInternal muteParticipantsRequest) {
        return FluxUtil.withContext(context -> this.muteWithResponseAsync(callConnectionId, muteParticipantsRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MuteParticipantsResultInternal>> muteWithResponseAsync(String callConnectionId, MuteParticipantsRequestInternal muteParticipantsRequest, Context context) {
        String accept = "application/json";
        return this.service.mute(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), muteParticipantsRequest, "application/json", CoreUtils.randomUuid().toString(), DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now()), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MuteParticipantsResultInternal> muteAsync(String callConnectionId, MuteParticipantsRequestInternal muteParticipantsRequest) {
        return this.muteWithResponseAsync(callConnectionId, muteParticipantsRequest).flatMap(res -> Mono.justOrEmpty((Object)((MuteParticipantsResultInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MuteParticipantsResultInternal> muteAsync(String callConnectionId, MuteParticipantsRequestInternal muteParticipantsRequest, Context context) {
        return this.muteWithResponseAsync(callConnectionId, muteParticipantsRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((MuteParticipantsResultInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MuteParticipantsResultInternal> muteWithResponse(String callConnectionId, MuteParticipantsRequestInternal muteParticipantsRequest, Context context) {
        return (Response)this.muteWithResponseAsync(callConnectionId, muteParticipantsRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MuteParticipantsResultInternal mute(String callConnectionId, MuteParticipantsRequestInternal muteParticipantsRequest) {
        return (MuteParticipantsResultInternal)this.muteWithResponse(callConnectionId, muteParticipantsRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CancelAddParticipantResponse>> cancelAddParticipantWithResponseAsync(String callConnectionId, CancelAddParticipantRequest cancelAddParticipantRequest) {
        return FluxUtil.withContext(context -> this.cancelAddParticipantWithResponseAsync(callConnectionId, cancelAddParticipantRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CancelAddParticipantResponse>> cancelAddParticipantWithResponseAsync(String callConnectionId, CancelAddParticipantRequest cancelAddParticipantRequest, Context context) {
        String accept = "application/json";
        return this.service.cancelAddParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), cancelAddParticipantRequest, "application/json", CoreUtils.randomUuid().toString(), DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now()), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CancelAddParticipantResponse> cancelAddParticipantAsync(String callConnectionId, CancelAddParticipantRequest cancelAddParticipantRequest) {
        return this.cancelAddParticipantWithResponseAsync(callConnectionId, cancelAddParticipantRequest).flatMap(res -> Mono.justOrEmpty((Object)((CancelAddParticipantResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CancelAddParticipantResponse> cancelAddParticipantAsync(String callConnectionId, CancelAddParticipantRequest cancelAddParticipantRequest, Context context) {
        return this.cancelAddParticipantWithResponseAsync(callConnectionId, cancelAddParticipantRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((CancelAddParticipantResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CancelAddParticipantResponse> cancelAddParticipantWithResponse(String callConnectionId, CancelAddParticipantRequest cancelAddParticipantRequest, Context context) {
        return (Response)this.cancelAddParticipantWithResponseAsync(callConnectionId, cancelAddParticipantRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CancelAddParticipantResponse cancelAddParticipant(String callConnectionId, CancelAddParticipantRequest cancelAddParticipantRequest) {
        return (CancelAddParticipantResponse)this.cancelAddParticipantWithResponse(callConnectionId, cancelAddParticipantRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallParticipantInternal>> getParticipantWithResponseAsync(String callConnectionId, String participantRawId) {
        return FluxUtil.withContext(context -> this.getParticipantWithResponseAsync(callConnectionId, participantRawId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallParticipantInternal>> getParticipantWithResponseAsync(String callConnectionId, String participantRawId, Context context) {
        String accept = "application/json";
        return this.service.getParticipant(this.client.getEndpoint(), callConnectionId, participantRawId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallParticipantInternal> getParticipantAsync(String callConnectionId, String participantRawId) {
        return this.getParticipantWithResponseAsync(callConnectionId, participantRawId).flatMap(res -> Mono.justOrEmpty((Object)((CallParticipantInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallParticipantInternal> getParticipantAsync(String callConnectionId, String participantRawId, Context context) {
        return this.getParticipantWithResponseAsync(callConnectionId, participantRawId, context).flatMap(res -> Mono.justOrEmpty((Object)((CallParticipantInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallParticipantInternal> getParticipantWithResponse(String callConnectionId, String participantRawId, Context context) {
        return (Response)this.getParticipantWithResponseAsync(callConnectionId, participantRawId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallParticipantInternal getParticipant(String callConnectionId, String participantRawId) {
        return (CallParticipantInternal)this.getParticipantWithResponse(callConnectionId, participantRawId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getParticipantsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetParticipantsResponseInternal)res.getValue()).getValue(), ((GetParticipantsResponseInternal)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getParticipantsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetParticipantsResponseInternal)res.getValue()).getValue(), ((GetParticipantsResponseInternal)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CallParticipantInternal> getParticipantsNextSinglePage(String nextLink) {
        return (PagedResponse)this.getParticipantsNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<CallParticipantInternal> getParticipantsNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.getParticipantsNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCallAutomationServiceCallConnections")
    public static interface CallConnectionsService {
        @Get(value="/calling/callConnections/{callConnectionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CallConnectionPropertiesInternal>> getCall(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/calling/callConnections/{callConnectionId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> hangupCall(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/calling/callConnections/{callConnectionId}:terminate")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> terminateCall(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @HeaderParam(value="repeatability-request-id") String var5, @HeaderParam(value="repeatability-first-sent") String var6, Context var7);

        @Post(value="/calling/callConnections/{callConnectionId}:transferToParticipant")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<TransferCallResponseInternal>> transferToParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") TransferToParticipantRequestInternal var4, @HeaderParam(value="Accept") String var5, @HeaderParam(value="repeatability-request-id") String var6, @HeaderParam(value="repeatability-first-sent") String var7, Context var8);

        @Get(value="/calling/callConnections/{callConnectionId}/participants")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<GetParticipantsResponseInternal>> getParticipants(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/calling/callConnections/{callConnectionId}/participants:add")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<AddParticipantResponseInternal>> addParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") AddParticipantRequestInternal var4, @HeaderParam(value="Accept") String var5, @HeaderParam(value="repeatability-request-id") String var6, @HeaderParam(value="repeatability-first-sent") String var7, Context var8);

        @Post(value="/calling/callConnections/{callConnectionId}/participants:remove")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<RemoveParticipantResponseInternal>> removeParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") RemoveParticipantRequestInternal var4, @HeaderParam(value="Accept") String var5, @HeaderParam(value="repeatability-request-id") String var6, @HeaderParam(value="repeatability-first-sent") String var7, Context var8);

        @Post(value="/calling/callConnections/{callConnectionId}/participants:mute")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<MuteParticipantsResultInternal>> mute(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") MuteParticipantsRequestInternal var4, @HeaderParam(value="Accept") String var5, @HeaderParam(value="repeatability-request-id") String var6, @HeaderParam(value="repeatability-first-sent") String var7, Context var8);

        @Post(value="/calling/callConnections/{callConnectionId}/participants:cancelAddParticipant")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CancelAddParticipantResponse>> cancelAddParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CancelAddParticipantRequest var4, @HeaderParam(value="Accept") String var5, @HeaderParam(value="repeatability-request-id") String var6, @HeaderParam(value="repeatability-first-sent") String var7, Context var8);

        @Get(value="/calling/callConnections/{callConnectionId}/participants/{participantRawId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CallParticipantInternal>> getParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @PathParam(value="participantRawId", encoded=true) String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<GetParticipantsResponseInternal>> getParticipantsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

