// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.models.events;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The StartRecordingFailed model.
 */
@Fluent
public final class StartRecordingFailed extends CallAutomationEventBase {
    /*
     * The call recording Id.
     */
    private String recordingId;

    /**
     * Creates an instance of StartRecordingFailed class.
     */
    public StartRecordingFailed() {
    }

    /**
     * Get the recordingId property: The call recording Id.
     *
     * @return the recordingId value.
     */
    public String getRecordingId() {
        return recordingId;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recordingId", recordingId);
        super.writeFields(jsonWriter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StartRecordingFailed from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of StartRecordingFailed if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StartRecordingFailed.
     */
    public static StartRecordingFailed fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            final StartRecordingFailed event = new StartRecordingFailed();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recordingId".equals(fieldName)) {
                    event.recordingId = reader.getString();
                } else {
                    if (!event.readField(fieldName, reader)) {
                        reader.skipChildren();
                    }
                }
            }

            return event;
        });
    }
}
