// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** Defines values for RecordingFormat. */
public final class RecordingFormat extends ExpandableStringEnum<RecordingFormat> {
    /** Static value wav for RecordingFormat. */
    public static final RecordingFormat WAV = fromString("wav");

    /** Static value mp3 for RecordingFormat. */
    public static final RecordingFormat MP3 = fromString("mp3");

    /** Static value mp4 for RecordingFormat. */
    public static final RecordingFormat MP4 = fromString("mp4");

    /**
     * Creates an instance of {@link RecordingFormat} with no string value.
     *
     * @deprecated Please use {@link #fromString(String)} to create an instance of RecordingFormat.
     */
    @Deprecated
    public RecordingFormat() {
    }

    /**
     * Creates or finds a RecordingFormat from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RecordingFormat.
     */
    public static RecordingFormat fromString(String name) {
        return fromString(name, RecordingFormat.class);
    }

    /**
     * Get the collection of RecordingFormat values.
     * @return known RecordingFormat values.
     */
    public static Collection<RecordingFormat> values() {
        return values(RecordingFormat.class);
    }
}
