// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.models;

import com.azure.core.annotation.Immutable;
import com.azure.communication.callautomation.implementation.models.MediaStreamingSubscriptionInternal;
import com.azure.communication.callautomation.implementation.accesshelpers.MediaStreamingSubscriptionConstructorProxy;
import java.util.List;
import java.util.stream.Collectors;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.json.JsonSerializable;

import java.io.IOException;

/**
 * Media streaming Subscription Object.
 */
@Immutable
public final class MediaStreamingSubscription implements JsonSerializable<MediaStreamingSubscription> {
    /*
     * Gets or Sets subscription Id.
     */
    private String id;

    /*
     * Gets or Sets media streaming subscription state.
     */
    private MediaStreamingSubscriptionState state;

    /*
     * Gets or Sets the subscribed media streaming content types.
     */
    private List<MediaStreamingContentType> subscribedContentTypes;

    static {
        MediaStreamingSubscriptionConstructorProxy.setAccessor(
            new MediaStreamingSubscriptionConstructorProxy.MediaStreamingSubscriptionConstructorAccessor() {
                @Override
                public MediaStreamingSubscription create(MediaStreamingSubscriptionInternal internalHeaders) {
                    return new MediaStreamingSubscription(internalHeaders);
                }
            });
    }

    /**
     * Creates an instance of MediaStreamingSubscription class.
     */
    MediaStreamingSubscription() {
        id = null;
        state = null;
        subscribedContentTypes = null;
    }

    /**
    * Package-private constructor of the class, used internally.
    *
    * @param mediaStreamingSubscriptionInternal The internal response of MediaStreamingSubscription
    */
    MediaStreamingSubscription(MediaStreamingSubscriptionInternal mediaStreamingSubscriptionInternal) {
        this.id
            = mediaStreamingSubscriptionInternal.getId() != null ? mediaStreamingSubscriptionInternal.getId() : null;
        this.state = mediaStreamingSubscriptionInternal.getState() != null
            ? MediaStreamingSubscriptionState.fromString(mediaStreamingSubscriptionInternal.getState().toString())
            : null;
        this.subscribedContentTypes = mediaStreamingSubscriptionInternal.getSubscribedContentTypes() != null
            ? mediaStreamingSubscriptionInternal.getSubscribedContentTypes()
                .stream()
                .map(contentType -> MediaStreamingContentType.fromString(contentType.toString()))
                .collect(Collectors.toList())
            : null;
    }

    /**
     * Get the id property: Gets or Sets subscription Id.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the state property: Gets or Sets media streaming subscription state.
     *
     * @return the state value.
     */
    public MediaStreamingSubscriptionState getState() {
        return this.state;
    }

    /**
     * Get the subscribedContentTypes property: Gets or Sets the subscribed media streaming content types.
     *
     * @return the subscribedContentTypes value.
     */
    public List<MediaStreamingContentType> getSubscribedContentTypes() {
        return this.subscribedContentTypes;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("subscribedContentTypes", this.subscribedContentTypes,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaStreamingSubscriptionInternal from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaStreamingSubscriptionInternal if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MediaStreamingSubscriptionInternal.
     */
    public static MediaStreamingSubscription fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaStreamingSubscription deserializedMediaStreamingSubscription = new MediaStreamingSubscription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMediaStreamingSubscription.id = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedMediaStreamingSubscription.state
                        = MediaStreamingSubscriptionState.fromString(reader.getString());
                } else if ("subscribedContentTypes".equals(fieldName)) {
                    List<MediaStreamingContentType> subscribedContentTypes
                        = reader.readArray(reader1 -> MediaStreamingContentType.fromString(reader1.getString()));
                    deserializedMediaStreamingSubscription.subscribedContentTypes = subscribedContentTypes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMediaStreamingSubscription;
        });
    }
}
