// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.models;

import com.azure.core.util.ExpandableStringEnum;

import java.util.Collection;

/** Defines values for MediaStreamingContentType. */
public final class MediaStreamingContentType extends ExpandableStringEnum<MediaStreamingContentType> {
    /** Static value audio for MediaStreamingContentType. */
    public static final MediaStreamingContentType AUDIO = fromString("audio");

    /**
     * Creates an instance of {@link MediaStreamingContentType} with no string value.
     *
     * @deprecated Please use {@link #fromString(String)} to create an instance of MediaStreamingContentType.
     */
    @Deprecated
    public MediaStreamingContentType() {
    }

    /**
     * Creates or finds a MediaStreamingContentType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MediaStreamingContentType.
     */
    public static MediaStreamingContentType fromString(String name) {
        return fromString(name, MediaStreamingContentType.class);
    }

    /**
     * Get the collection of MediaStreamingContentType values.
     * @return known MediaStreamingContentType values.
     */
    public static Collection<MediaStreamingContentType> values() {
        return values(MediaStreamingContentType.class);
    }
}
