// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** Defines values for MediaStreamingAudioChannelType. */
public final class MediaStreamingAudioChannel extends ExpandableStringEnum<MediaStreamingAudioChannel> {
    /** Static value mixed for MediaStreamingAudioChannelType. */
    public static final MediaStreamingAudioChannel MIXED = fromString("mixed");

    /** Static value unmixed for MediaStreamingAudioChannelType. */
    public static final MediaStreamingAudioChannel UNMIXED = fromString("unmixed");

    /**
     * Creates an instance of {@link MediaStreamingAudioChannel} with no string value.
     *
     * @deprecated Please use {@link #fromString(String)} to create an instance of MediaStreamingAudioChannel.
     */
    @Deprecated
    public MediaStreamingAudioChannel() {
    }

    /**
     * Creates or finds a MediaStreamingAudioChannelType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MediaStreamingAudioChannelType.
     */
    public static MediaStreamingAudioChannel fromString(String name) {
        return fromString(name, MediaStreamingAudioChannel.class);
    }

    /**
     * Get the collection of MediaStreamingAudioChannelType values.
     * @return known MediaStreamingAudioChannelType values.
     */
    public static Collection<MediaStreamingAudioChannel> values() {
        return values(MediaStreamingAudioChannel.class);
    }
}
