// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

/** The DtmfResult model. */
@Fluent
public final class DtmfResult extends RecognizeResult {
    /*
     * The tones property.
     */
    private List<DtmfTone> dtmfTones;

    /**
     * Creates an instance of {@link DtmfResult}.
     */
    public DtmfResult() {
    }

    /**
     * Get the tones property: The tones property.
     *
     * @return the tones value.
     */
    public List<DtmfTone> getTones() {
        return this.dtmfTones;
    }

    /**
     * Set the tones property: The tones property.
     *
     * @param dtmfTones the tones value to set.
     * @return the DtmfResult object itself.
     */
    public DtmfResult setTones(List<DtmfTone> dtmfTones) {
        this.dtmfTones = dtmfTones;
        return this;
    }

    /**
     * Set the tones property: The tones property.
     *
     * @return the DtmfResult object itself.
     */
    public String convertToString() {
        if (this.dtmfTones == null) {
            return "";
        }

        return this.dtmfTones.stream().map(x -> x.convertToString()).collect(Collectors.joining());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tones", this.dtmfTones,
            (writer, element) -> writer.writeString(element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Word from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of Word if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the Word.
     */
    public static DtmfResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DtmfResult result = new DtmfResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tones".equals(fieldName)) {
                    result.dtmfTones = reader.readArray(r -> DtmfTone.fromString(r.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            return result;
        });
    }
}
