// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.models;

import com.azure.core.util.ExpandableStringEnum;

import java.util.Collection;

/** Defines values for CallConnectionState. */
public final class CallConnectionState extends ExpandableStringEnum<CallConnectionState> {
    /** Static value connecting for CallConnectionState. */
    public static final CallConnectionState CONNECTING = fromString("connecting");

    /** Static value connected for CallConnectionState. */
    public static final CallConnectionState CONNECTED = fromString("connected");

    /** Static value transferring for CallConnectionState. */
    public static final CallConnectionState TRANSFERRING = fromString("transferring");

    /** Static value transferAccepted for CallConnectionState. */
    public static final CallConnectionState TRANSFER_ACCEPTED = fromString("transferAccepted");

    /** Static value disconnecting for CallConnectionState. */
    public static final CallConnectionState DISCONNECTING = fromString("disconnecting");

    /** Static value disconnected for CallConnectionState. */
    public static final CallConnectionState DISCONNECTED = fromString("disconnected");

    /**
     * Creates or finds a CallConnectionState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding CallConnectionState.
     */

    public static CallConnectionState fromString(String name) {
        return fromString(name, CallConnectionState.class);
    }

    /** Return values
     * @return known CallConnectionState values.
     */
    public static Collection<CallConnectionState> values() {
        return values(CallConnectionState.class);
    }

    /**
     * Private constructor
     */
    public CallConnectionState() {

    }
}
