// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the options for WebSocket transport.
 */
@Fluent
public final class WebSocketTranscriptionOptionsInternal extends TranscriptionOptionsInternal {
    /*
     * Defines the transport type used for streaming. Note that future values may be introduced that are not currently
     * documented.
     */
    @Generated
    private StreamingTransportTypeInternal transportType = StreamingTransportTypeInternal.WEBSOCKET;

    /*
     * The URL used for live transcription transport.
     */
    @Generated
    private String transportUrl;

    /*
     * The ID of the deployed custom model in GUID format. The GUID is generated by Azure Speech Studio, e.g.,
     * a259c255-1cdw-4ed7-a693-dd58563b6f6a.
     */
    @Generated
    private String speechModelEndpointId;

    /*
     * Indicates whether the transcription should start immediately after the call is answered.
     */
    @Generated
    private Boolean startTranscription;

    /*
     * Enables intermediate results for the transcribed speech.
     */
    @Generated
    private Boolean enableIntermediateResults;

    /**
     * Creates an instance of WebSocketTranscriptionOptionsInternal class.
     */
    @Generated
    public WebSocketTranscriptionOptionsInternal() {
    }

    /**
     * Get the transportType property: Defines the transport type used for streaming. Note that future values may be
     * introduced that are not currently documented.
     * 
     * @return the transportType value.
     */
    @Generated
    @Override
    public StreamingTransportTypeInternal getTransportType() {
        return this.transportType;
    }

    /**
     * Get the transportUrl property: The URL used for live transcription transport.
     * 
     * @return the transportUrl value.
     */
    @Generated
    public String getTransportUrl() {
        return this.transportUrl;
    }

    /**
     * Set the transportUrl property: The URL used for live transcription transport.
     * 
     * @param transportUrl the transportUrl value to set.
     * @return the WebSocketTranscriptionOptionsInternal object itself.
     */
    @Generated
    public WebSocketTranscriptionOptionsInternal setTransportUrl(String transportUrl) {
        this.transportUrl = transportUrl;
        return this;
    }

    /**
     * Get the speechModelEndpointId property: The ID of the deployed custom model in GUID format. The GUID is generated
     * by Azure Speech Studio, e.g., a259c255-1cdw-4ed7-a693-dd58563b6f6a.
     * 
     * @return the speechModelEndpointId value.
     */
    @Generated
    public String getSpeechModelEndpointId() {
        return this.speechModelEndpointId;
    }

    /**
     * Set the speechModelEndpointId property: The ID of the deployed custom model in GUID format. The GUID is generated
     * by Azure Speech Studio, e.g., a259c255-1cdw-4ed7-a693-dd58563b6f6a.
     * 
     * @param speechModelEndpointId the speechModelEndpointId value to set.
     * @return the WebSocketTranscriptionOptionsInternal object itself.
     */
    @Generated
    public WebSocketTranscriptionOptionsInternal setSpeechModelEndpointId(String speechModelEndpointId) {
        this.speechModelEndpointId = speechModelEndpointId;
        return this;
    }

    /**
     * Get the startTranscription property: Indicates whether the transcription should start immediately after the call
     * is answered.
     * 
     * @return the startTranscription value.
     */
    @Generated
    public Boolean isStartTranscription() {
        return this.startTranscription;
    }

    /**
     * Set the startTranscription property: Indicates whether the transcription should start immediately after the call
     * is answered.
     * 
     * @param startTranscription the startTranscription value to set.
     * @return the WebSocketTranscriptionOptionsInternal object itself.
     */
    @Generated
    public WebSocketTranscriptionOptionsInternal setStartTranscription(Boolean startTranscription) {
        this.startTranscription = startTranscription;
        return this;
    }

    /**
     * Get the enableIntermediateResults property: Enables intermediate results for the transcribed speech.
     * 
     * @return the enableIntermediateResults value.
     */
    @Generated
    public Boolean isEnableIntermediateResults() {
        return this.enableIntermediateResults;
    }

    /**
     * Set the enableIntermediateResults property: Enables intermediate results for the transcribed speech.
     * 
     * @param enableIntermediateResults the enableIntermediateResults value to set.
     * @return the WebSocketTranscriptionOptionsInternal object itself.
     */
    @Generated
    public WebSocketTranscriptionOptionsInternal setEnableIntermediateResults(Boolean enableIntermediateResults) {
        this.enableIntermediateResults = enableIntermediateResults;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebSocketTranscriptionOptionsInternal setLocale(String locale) {
        super.setLocale(locale);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("locale", getLocale());
        jsonWriter.writeStringField("transportType", this.transportType == null ? null : this.transportType.toString());
        jsonWriter.writeStringField("transportUrl", this.transportUrl);
        jsonWriter.writeStringField("speechModelEndpointId", this.speechModelEndpointId);
        jsonWriter.writeBooleanField("startTranscription", this.startTranscription);
        jsonWriter.writeBooleanField("enableIntermediateResults", this.enableIntermediateResults);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebSocketTranscriptionOptionsInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebSocketTranscriptionOptionsInternal if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebSocketTranscriptionOptionsInternal.
     */
    @Generated
    public static WebSocketTranscriptionOptionsInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebSocketTranscriptionOptionsInternal deserializedWebSocketTranscriptionOptionsInternal
                = new WebSocketTranscriptionOptionsInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("locale".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.setLocale(reader.getString());
                } else if ("transportType".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.transportType
                        = StreamingTransportTypeInternal.fromString(reader.getString());
                } else if ("transportUrl".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.transportUrl = reader.getString();
                } else if ("speechModelEndpointId".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.speechModelEndpointId = reader.getString();
                } else if ("startTranscription".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.startTranscription
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableIntermediateResults".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.enableIntermediateResults
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebSocketTranscriptionOptionsInternal;
        });
    }
}
