// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the options for WebSocket transport.
 */
@Fluent
public final class WebSocketMediaStreamingOptionsInternal extends MediaStreamingOptionsInternal {
    /*
     * Defines the transport type used for streaming. Note that future values may be introduced that are not currently
     * documented.
     */
    @Generated
    private StreamingTransportTypeInternal transportType = StreamingTransportTypeInternal.WEBSOCKET;

    /*
     * The transport URL for media streaming.
     */
    @Generated
    private String transportUrl;

    /*
     * The contentType property.
     */
    @Generated
    private MediaStreamingContentTypeInternal contentType;

    /*
     * A value indicating whether the media streaming should start immediately after the call is answered.
     */
    @Generated
    private Boolean startMediaStreaming;

    /*
     * A value indicating whether bidirectional streaming is enabled.
     */
    @Generated
    private Boolean enableBidirectional;

    /*
     * The audio format used for encoding, including sample rate and channel type. The default is Pcm16KMono.
     */
    @Generated
    private AudioFormatInternal audioFormat;

    /*
     * A value that indicates whether to stream the DTMF tones.
     */
    @Generated
    private Boolean enableDtmfTones;

    /**
     * Creates an instance of WebSocketMediaStreamingOptionsInternal class.
     */
    @Generated
    public WebSocketMediaStreamingOptionsInternal() {
    }

    /**
     * Get the transportType property: Defines the transport type used for streaming. Note that future values may be
     * introduced that are not currently documented.
     * 
     * @return the transportType value.
     */
    @Generated
    @Override
    public StreamingTransportTypeInternal getTransportType() {
        return this.transportType;
    }

    /**
     * Get the transportUrl property: The transport URL for media streaming.
     * 
     * @return the transportUrl value.
     */
    @Generated
    public String getTransportUrl() {
        return this.transportUrl;
    }

    /**
     * Set the transportUrl property: The transport URL for media streaming.
     * 
     * @param transportUrl the transportUrl value to set.
     * @return the WebSocketMediaStreamingOptionsInternal object itself.
     */
    @Generated
    public WebSocketMediaStreamingOptionsInternal setTransportUrl(String transportUrl) {
        this.transportUrl = transportUrl;
        return this;
    }

    /**
     * Get the contentType property: The contentType property.
     * 
     * @return the contentType value.
     */
    @Generated
    public MediaStreamingContentTypeInternal getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The contentType property.
     * 
     * @param contentType the contentType value to set.
     * @return the WebSocketMediaStreamingOptionsInternal object itself.
     */
    @Generated
    public WebSocketMediaStreamingOptionsInternal setContentType(MediaStreamingContentTypeInternal contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the startMediaStreaming property: A value indicating whether the media streaming should start immediately
     * after the call is answered.
     * 
     * @return the startMediaStreaming value.
     */
    @Generated
    public Boolean isStartMediaStreaming() {
        return this.startMediaStreaming;
    }

    /**
     * Set the startMediaStreaming property: A value indicating whether the media streaming should start immediately
     * after the call is answered.
     * 
     * @param startMediaStreaming the startMediaStreaming value to set.
     * @return the WebSocketMediaStreamingOptionsInternal object itself.
     */
    @Generated
    public WebSocketMediaStreamingOptionsInternal setStartMediaStreaming(Boolean startMediaStreaming) {
        this.startMediaStreaming = startMediaStreaming;
        return this;
    }

    /**
     * Get the enableBidirectional property: A value indicating whether bidirectional streaming is enabled.
     * 
     * @return the enableBidirectional value.
     */
    @Generated
    public Boolean isEnableBidirectional() {
        return this.enableBidirectional;
    }

    /**
     * Set the enableBidirectional property: A value indicating whether bidirectional streaming is enabled.
     * 
     * @param enableBidirectional the enableBidirectional value to set.
     * @return the WebSocketMediaStreamingOptionsInternal object itself.
     */
    @Generated
    public WebSocketMediaStreamingOptionsInternal setEnableBidirectional(Boolean enableBidirectional) {
        this.enableBidirectional = enableBidirectional;
        return this;
    }

    /**
     * Get the audioFormat property: The audio format used for encoding, including sample rate and channel type. The
     * default is Pcm16KMono.
     * 
     * @return the audioFormat value.
     */
    @Generated
    public AudioFormatInternal getAudioFormat() {
        return this.audioFormat;
    }

    /**
     * Set the audioFormat property: The audio format used for encoding, including sample rate and channel type. The
     * default is Pcm16KMono.
     * 
     * @param audioFormat the audioFormat value to set.
     * @return the WebSocketMediaStreamingOptionsInternal object itself.
     */
    @Generated
    public WebSocketMediaStreamingOptionsInternal setAudioFormat(AudioFormatInternal audioFormat) {
        this.audioFormat = audioFormat;
        return this;
    }

    /**
     * Get the enableDtmfTones property: A value that indicates whether to stream the DTMF tones.
     * 
     * @return the enableDtmfTones value.
     */
    @Generated
    public Boolean isEnableDtmfTones() {
        return this.enableDtmfTones;
    }

    /**
     * Set the enableDtmfTones property: A value that indicates whether to stream the DTMF tones.
     * 
     * @param enableDtmfTones the enableDtmfTones value to set.
     * @return the WebSocketMediaStreamingOptionsInternal object itself.
     */
    @Generated
    public WebSocketMediaStreamingOptionsInternal setEnableDtmfTones(Boolean enableDtmfTones) {
        this.enableDtmfTones = enableDtmfTones;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebSocketMediaStreamingOptionsInternal
        setAudioChannelType(MediaStreamingAudioChannelTypeInternal audioChannelType) {
        super.setAudioChannelType(audioChannelType);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("audioChannelType",
            getAudioChannelType() == null ? null : getAudioChannelType().toString());
        jsonWriter.writeStringField("transportType", this.transportType == null ? null : this.transportType.toString());
        jsonWriter.writeStringField("transportUrl", this.transportUrl);
        jsonWriter.writeStringField("contentType", this.contentType == null ? null : this.contentType.toString());
        jsonWriter.writeBooleanField("startMediaStreaming", this.startMediaStreaming);
        jsonWriter.writeBooleanField("enableBidirectional", this.enableBidirectional);
        jsonWriter.writeStringField("audioFormat", this.audioFormat == null ? null : this.audioFormat.toString());
        jsonWriter.writeBooleanField("enableDtmfTones", this.enableDtmfTones);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebSocketMediaStreamingOptionsInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebSocketMediaStreamingOptionsInternal if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebSocketMediaStreamingOptionsInternal.
     */
    @Generated
    public static WebSocketMediaStreamingOptionsInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebSocketMediaStreamingOptionsInternal deserializedWebSocketMediaStreamingOptionsInternal
                = new WebSocketMediaStreamingOptionsInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("audioChannelType".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal
                        .setAudioChannelType(MediaStreamingAudioChannelTypeInternal.fromString(reader.getString()));
                } else if ("transportType".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.transportType
                        = StreamingTransportTypeInternal.fromString(reader.getString());
                } else if ("transportUrl".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.transportUrl = reader.getString();
                } else if ("contentType".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.contentType
                        = MediaStreamingContentTypeInternal.fromString(reader.getString());
                } else if ("startMediaStreaming".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.startMediaStreaming
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableBidirectional".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.enableBidirectional
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("audioFormat".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.audioFormat
                        = AudioFormatInternal.fromString(reader.getString());
                } else if ("enableDtmfTones".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.enableDtmfTones
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebSocketMediaStreamingOptionsInternal;
        });
    }
}
