// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The response payload for unmuting participants from the call.
 */
@Fluent
public final class UnmuteParticipantsResponseInternal implements JsonSerializable<UnmuteParticipantsResponseInternal> {
    /*
     * The operation context provided by client.
     */
    private String operationContext;

    /**
     * Creates an instance of UnmuteParticipantsResponseInternal class.
     */
    public UnmuteParticipantsResponseInternal() {
    }

    /**
     * Get the operationContext property: The operation context provided by client.
     * 
     * @return the operationContext value.
     */
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: The operation context provided by client.
     * 
     * @param operationContext the operationContext value to set.
     * @return the UnmuteParticipantsResponseInternal object itself.
     */
    public UnmuteParticipantsResponseInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationContext", this.operationContext);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UnmuteParticipantsResponseInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UnmuteParticipantsResponseInternal if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UnmuteParticipantsResponseInternal.
     */
    public static UnmuteParticipantsResponseInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UnmuteParticipantsResponseInternal deserializedUnmuteParticipantsResponseInternal
                = new UnmuteParticipantsResponseInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operationContext".equals(fieldName)) {
                    deserializedUnmuteParticipantsResponseInternal.operationContext = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUnmuteParticipantsResponseInternal;
        });
    }
}
