// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The TranscriptionUpdate model.
 */
@Fluent
public final class TranscriptionUpdate implements JsonSerializable<TranscriptionUpdate> {
    /*
     * The transcriptionStatus property.
     */
    @Generated
    private TranscriptionStatus transcriptionStatus;

    /*
     * The transcriptionStatusDetails property.
     */
    @Generated
    private TranscriptionStatusDetails transcriptionStatusDetails;

    /**
     * Creates an instance of TranscriptionUpdate class.
     */
    @Generated
    public TranscriptionUpdate() {
    }

    /**
     * Get the transcriptionStatus property: The transcriptionStatus property.
     * 
     * @return the transcriptionStatus value.
     */
    @Generated
    public TranscriptionStatus getTranscriptionStatus() {
        return this.transcriptionStatus;
    }

    /**
     * Set the transcriptionStatus property: The transcriptionStatus property.
     * 
     * @param transcriptionStatus the transcriptionStatus value to set.
     * @return the TranscriptionUpdate object itself.
     */
    @Generated
    public TranscriptionUpdate setTranscriptionStatus(TranscriptionStatus transcriptionStatus) {
        this.transcriptionStatus = transcriptionStatus;
        return this;
    }

    /**
     * Get the transcriptionStatusDetails property: The transcriptionStatusDetails property.
     * 
     * @return the transcriptionStatusDetails value.
     */
    @Generated
    public TranscriptionStatusDetails getTranscriptionStatusDetails() {
        return this.transcriptionStatusDetails;
    }

    /**
     * Set the transcriptionStatusDetails property: The transcriptionStatusDetails property.
     * 
     * @param transcriptionStatusDetails the transcriptionStatusDetails value to set.
     * @return the TranscriptionUpdate object itself.
     */
    @Generated
    public TranscriptionUpdate setTranscriptionStatusDetails(TranscriptionStatusDetails transcriptionStatusDetails) {
        this.transcriptionStatusDetails = transcriptionStatusDetails;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transcriptionStatus",
            this.transcriptionStatus == null ? null : this.transcriptionStatus.toString());
        jsonWriter.writeStringField("transcriptionStatusDetails",
            this.transcriptionStatusDetails == null ? null : this.transcriptionStatusDetails.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TranscriptionUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TranscriptionUpdate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TranscriptionUpdate.
     */
    @Generated
    public static TranscriptionUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TranscriptionUpdate deserializedTranscriptionUpdate = new TranscriptionUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("transcriptionStatus".equals(fieldName)) {
                    deserializedTranscriptionUpdate.transcriptionStatus
                        = TranscriptionStatus.fromString(reader.getString());
                } else if ("transcriptionStatusDetails".equals(fieldName)) {
                    deserializedTranscriptionUpdate.transcriptionStatusDetails
                        = TranscriptionStatusDetails.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTranscriptionUpdate;
        });
    }
}
