// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Transcription Subscription Object.
 */
@Fluent
public final class TranscriptionSubscriptionInternal implements JsonSerializable<TranscriptionSubscriptionInternal> {
    /*
     * Subscription Id.
     */
    @Generated
    private String id;

    /*
     * Transcription subscription state.
     */
    @Generated
    private TranscriptionSubscriptionStateInternal state;

    /*
     * Subscribed transcription result types.
     */
    @Generated
    private List<TranscriptionResultTypeInternal> subscribedResultTypes;

    /*
     * Specifies the locale used for transcription, e.g., en-CA or en-AU.
     */
    @Generated
    private String locale;

    /**
     * Creates an instance of TranscriptionSubscriptionInternal class.
     */
    @Generated
    public TranscriptionSubscriptionInternal() {
    }

    /**
     * Get the id property: Subscription Id.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: Subscription Id.
     * 
     * @param id the id value to set.
     * @return the TranscriptionSubscriptionInternal object itself.
     */
    @Generated
    public TranscriptionSubscriptionInternal setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the state property: Transcription subscription state.
     * 
     * @return the state value.
     */
    @Generated
    public TranscriptionSubscriptionStateInternal getState() {
        return this.state;
    }

    /**
     * Set the state property: Transcription subscription state.
     * 
     * @param state the state value to set.
     * @return the TranscriptionSubscriptionInternal object itself.
     */
    @Generated
    public TranscriptionSubscriptionInternal setState(TranscriptionSubscriptionStateInternal state) {
        this.state = state;
        return this;
    }

    /**
     * Get the subscribedResultTypes property: Subscribed transcription result types.
     * 
     * @return the subscribedResultTypes value.
     */
    @Generated
    public List<TranscriptionResultTypeInternal> getSubscribedResultTypes() {
        return this.subscribedResultTypes;
    }

    /**
     * Set the subscribedResultTypes property: Subscribed transcription result types.
     * 
     * @param subscribedResultTypes the subscribedResultTypes value to set.
     * @return the TranscriptionSubscriptionInternal object itself.
     */
    @Generated
    public TranscriptionSubscriptionInternal
        setSubscribedResultTypes(List<TranscriptionResultTypeInternal> subscribedResultTypes) {
        this.subscribedResultTypes = subscribedResultTypes;
        return this;
    }

    /**
     * Get the locale property: Specifies the locale used for transcription, e.g., en-CA or en-AU.
     * 
     * @return the locale value.
     */
    @Generated
    public String getLocale() {
        return this.locale;
    }

    /**
     * Set the locale property: Specifies the locale used for transcription, e.g., en-CA or en-AU.
     * 
     * @param locale the locale value to set.
     * @return the TranscriptionSubscriptionInternal object itself.
     */
    @Generated
    public TranscriptionSubscriptionInternal setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("subscribedResultTypes", this.subscribedResultTypes,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("locale", this.locale);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TranscriptionSubscriptionInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TranscriptionSubscriptionInternal if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TranscriptionSubscriptionInternal.
     */
    @Generated
    public static TranscriptionSubscriptionInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TranscriptionSubscriptionInternal deserializedTranscriptionSubscriptionInternal
                = new TranscriptionSubscriptionInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTranscriptionSubscriptionInternal.id = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedTranscriptionSubscriptionInternal.state
                        = TranscriptionSubscriptionStateInternal.fromString(reader.getString());
                } else if ("subscribedResultTypes".equals(fieldName)) {
                    List<TranscriptionResultTypeInternal> subscribedResultTypes
                        = reader.readArray(reader1 -> TranscriptionResultTypeInternal.fromString(reader1.getString()));
                    deserializedTranscriptionSubscriptionInternal.subscribedResultTypes = subscribedResultTypes;
                } else if ("locale".equals(fieldName)) {
                    deserializedTranscriptionSubscriptionInternal.locale = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTranscriptionSubscriptionInternal;
        });
    }
}
