// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Transcription Subscription Object.
 */
@Fluent
public final class TranscriptionSubscription implements JsonSerializable<TranscriptionSubscription> {
    /*
     * Subscription Id.
     */
    private String id;

    /*
     * Transcription subscription state.
     */
    private TranscriptionSubscriptionState state;

    /*
     * Subscribed transcription result types.
     */
    private List<TranscriptionResultType> subscribedResultTypes;

    /**
     * Creates an instance of TranscriptionSubscription class.
     */
    public TranscriptionSubscription() {
    }

    /**
     * Get the id property: Subscription Id.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: Subscription Id.
     * 
     * @param id the id value to set.
     * @return the TranscriptionSubscription object itself.
     */
    public TranscriptionSubscription setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the state property: Transcription subscription state.
     * 
     * @return the state value.
     */
    public TranscriptionSubscriptionState getState() {
        return this.state;
    }

    /**
     * Set the state property: Transcription subscription state.
     * 
     * @param state the state value to set.
     * @return the TranscriptionSubscription object itself.
     */
    public TranscriptionSubscription setState(TranscriptionSubscriptionState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the subscribedResultTypes property: Subscribed transcription result types.
     * 
     * @return the subscribedResultTypes value.
     */
    public List<TranscriptionResultType> getSubscribedResultTypes() {
        return this.subscribedResultTypes;
    }

    /**
     * Set the subscribedResultTypes property: Subscribed transcription result types.
     * 
     * @param subscribedResultTypes the subscribedResultTypes value to set.
     * @return the TranscriptionSubscription object itself.
     */
    public TranscriptionSubscription setSubscribedResultTypes(List<TranscriptionResultType> subscribedResultTypes) {
        this.subscribedResultTypes = subscribedResultTypes;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("subscribedResultTypes", this.subscribedResultTypes,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TranscriptionSubscription from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TranscriptionSubscription if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TranscriptionSubscription.
     */
    public static TranscriptionSubscription fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TranscriptionSubscription deserializedTranscriptionSubscription = new TranscriptionSubscription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTranscriptionSubscription.id = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedTranscriptionSubscription.state
                        = TranscriptionSubscriptionState.fromString(reader.getString());
                } else if ("subscribedResultTypes".equals(fieldName)) {
                    List<TranscriptionResultType> subscribedResultTypes
                        = reader.readArray(reader1 -> TranscriptionResultType.fromString(reader1.getString()));
                    deserializedTranscriptionSubscription.subscribedResultTypes = subscribedResultTypes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTranscriptionSubscription;
        });
    }
}
