// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Options for live transcription.
 */
@Fluent
public class TranscriptionOptionsInternal implements JsonSerializable<TranscriptionOptionsInternal> {
    /*
     * Defines the transport type used for streaming. Note that future values may be introduced that are not currently
     * documented.
     */
    @Generated
    private StreamingTransportTypeInternal transportType
        = StreamingTransportTypeInternal.fromString("TranscriptionOptionsInternal");

    /*
     * Specifies the Locale used for transcription, e.g., en-CA or en-AU.
     */
    @Generated
    private String locale;

    /**
     * Creates an instance of TranscriptionOptionsInternal class.
     */
    @Generated
    public TranscriptionOptionsInternal() {
    }

    /**
     * Get the transportType property: Defines the transport type used for streaming. Note that future values may be
     * introduced that are not currently documented.
     * 
     * @return the transportType value.
     */
    @Generated
    public StreamingTransportTypeInternal getTransportType() {
        return this.transportType;
    }

    /**
     * Get the locale property: Specifies the Locale used for transcription, e.g., en-CA or en-AU.
     * 
     * @return the locale value.
     */
    @Generated
    public String getLocale() {
        return this.locale;
    }

    /**
     * Set the locale property: Specifies the Locale used for transcription, e.g., en-CA or en-AU.
     * 
     * @param locale the locale value to set.
     * @return the TranscriptionOptionsInternal object itself.
     */
    @Generated
    public TranscriptionOptionsInternal setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("locale", this.locale);
        jsonWriter.writeStringField("transportType", this.transportType == null ? null : this.transportType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TranscriptionOptionsInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TranscriptionOptionsInternal if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TranscriptionOptionsInternal.
     */
    @Generated
    public static TranscriptionOptionsInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("transportType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("websocket".equals(discriminatorValue)) {
                    return WebSocketTranscriptionOptionsInternal.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static TranscriptionOptionsInternal fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TranscriptionOptionsInternal deserializedTranscriptionOptionsInternal = new TranscriptionOptionsInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("locale".equals(fieldName)) {
                    deserializedTranscriptionOptionsInternal.locale = reader.getString();
                } else if ("transportType".equals(fieldName)) {
                    deserializedTranscriptionOptionsInternal.transportType
                        = StreamingTransportTypeInternal.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTranscriptionOptionsInternal;
        });
    }
}
