// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A Microsoft Teams Phone user who is using a Communication Services resource to extend their Teams Phone set up.
 */
@Fluent
public final class TeamsExtensionUserIdentifierModel implements JsonSerializable<TeamsExtensionUserIdentifierModel> {
    /*
     * The Id of the Microsoft Teams Extension user, i.e. the Entra ID object Id of the user.
     */
    @Generated
    private String userId;

    /*
     * The tenant Id of the Microsoft Teams Extension user.
     */
    @Generated
    private String tenantId;

    /*
     * The Communication Services resource Id.
     */
    @Generated
    private String resourceId;

    /*
     * The cloud that the Microsoft Teams Extension user belongs to. By default 'public' if missing.
     */
    @Generated
    private CommunicationCloudEnvironmentModel cloud;

    /**
     * Creates an instance of TeamsExtensionUserIdentifierModel class.
     */
    @Generated
    public TeamsExtensionUserIdentifierModel() {
    }

    /**
     * Get the userId property: The Id of the Microsoft Teams Extension user, i.e. the Entra ID object Id of the user.
     * 
     * @return the userId value.
     */
    @Generated
    public String getUserId() {
        return this.userId;
    }

    /**
     * Set the userId property: The Id of the Microsoft Teams Extension user, i.e. the Entra ID object Id of the user.
     * 
     * @param userId the userId value to set.
     * @return the TeamsExtensionUserIdentifierModel object itself.
     */
    @Generated
    public TeamsExtensionUserIdentifierModel setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * Get the tenantId property: The tenant Id of the Microsoft Teams Extension user.
     * 
     * @return the tenantId value.
     */
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The tenant Id of the Microsoft Teams Extension user.
     * 
     * @param tenantId the tenantId value to set.
     * @return the TeamsExtensionUserIdentifierModel object itself.
     */
    @Generated
    public TeamsExtensionUserIdentifierModel setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the resourceId property: The Communication Services resource Id.
     * 
     * @return the resourceId value.
     */
    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The Communication Services resource Id.
     * 
     * @param resourceId the resourceId value to set.
     * @return the TeamsExtensionUserIdentifierModel object itself.
     */
    @Generated
    public TeamsExtensionUserIdentifierModel setResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the cloud property: The cloud that the Microsoft Teams Extension user belongs to. By default 'public' if
     * missing.
     * 
     * @return the cloud value.
     */
    @Generated
    public CommunicationCloudEnvironmentModel getCloud() {
        return this.cloud;
    }

    /**
     * Set the cloud property: The cloud that the Microsoft Teams Extension user belongs to. By default 'public' if
     * missing.
     * 
     * @param cloud the cloud value to set.
     * @return the TeamsExtensionUserIdentifierModel object itself.
     */
    @Generated
    public TeamsExtensionUserIdentifierModel setCloud(CommunicationCloudEnvironmentModel cloud) {
        this.cloud = cloud;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userId", this.userId);
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("cloud", this.cloud == null ? null : this.cloud.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TeamsExtensionUserIdentifierModel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TeamsExtensionUserIdentifierModel if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TeamsExtensionUserIdentifierModel.
     */
    @Generated
    public static TeamsExtensionUserIdentifierModel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TeamsExtensionUserIdentifierModel deserializedTeamsExtensionUserIdentifierModel
                = new TeamsExtensionUserIdentifierModel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("userId".equals(fieldName)) {
                    deserializedTeamsExtensionUserIdentifierModel.userId = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedTeamsExtensionUserIdentifierModel.tenantId = reader.getString();
                } else if ("resourceId".equals(fieldName)) {
                    deserializedTeamsExtensionUserIdentifierModel.resourceId = reader.getString();
                } else if ("cloud".equals(fieldName)) {
                    deserializedTeamsExtensionUserIdentifierModel.cloud
                        = CommunicationCloudEnvironmentModel.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTeamsExtensionUserIdentifierModel;
        });
    }
}
