// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request payload for holding participant from the call.
 */
@Fluent
public final class StopHoldMusicRequestInternal implements JsonSerializable<StopHoldMusicRequestInternal> {
    /*
     * Participants to be hold from the call.
     * Only ACS Users are supported.
     */
    private CommunicationIdentifierModel targetParticipant;

    /*
     * Used by customers when calling mid-call actions to correlate the request to the response event.
     */
    private String operationContext;

    /**
     * Creates an instance of StopHoldMusicRequestInternal class.
     */
    public StopHoldMusicRequestInternal() {
    }

    /**
     * Get the targetParticipant property: Participants to be hold from the call.
     * Only ACS Users are supported.
     * 
     * @return the targetParticipant value.
     */
    public CommunicationIdentifierModel getTargetParticipant() {
        return this.targetParticipant;
    }

    /**
     * Set the targetParticipant property: Participants to be hold from the call.
     * Only ACS Users are supported.
     * 
     * @param targetParticipant the targetParticipant value to set.
     * @return the StopHoldMusicRequestInternal object itself.
     */
    public StopHoldMusicRequestInternal setTargetParticipant(CommunicationIdentifierModel targetParticipant) {
        this.targetParticipant = targetParticipant;
        return this;
    }

    /**
     * Get the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @return the operationContext value.
     */
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @param operationContext the operationContext value to set.
     * @return the StopHoldMusicRequestInternal object itself.
     */
    public StopHoldMusicRequestInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("targetParticipant", this.targetParticipant);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StopHoldMusicRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StopHoldMusicRequestInternal if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StopHoldMusicRequestInternal.
     */
    public static StopHoldMusicRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StopHoldMusicRequestInternal deserializedStopHoldMusicRequestInternal = new StopHoldMusicRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetParticipant".equals(fieldName)) {
                    deserializedStopHoldMusicRequestInternal.targetParticipant
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("operationContext".equals(fieldName)) {
                    deserializedStopHoldMusicRequestInternal.operationContext = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStopHoldMusicRequestInternal;
        });
    }
}
