// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The StartRecordingFailed model.
 */
@Fluent
public final class StartRecordingFailed implements JsonSerializable<StartRecordingFailed> {
    /*
     * The call recording Id.
     */
    @Generated
    private String recordingId;

    /*
     * Call connection ID.
     */
    @Generated
    private String callConnectionId;

    /*
     * Server call ID.
     */
    @Generated
    private String serverCallId;

    /*
     * Correlation ID for event to call correlation. Also called ChainId for skype chain ID.
     */
    @Generated
    private String correlationId;

    /*
     * Used by customers when calling mid-call actions to correlate the request to the response event.
     */
    @Generated
    private String operationContext;

    /*
     * Contains the resulting SIP code, sub-code and message.
     */
    @Generated
    private ResultInformation resultInformation;

    /**
     * Creates an instance of StartRecordingFailed class.
     */
    @Generated
    public StartRecordingFailed() {
    }

    /**
     * Get the recordingId property: The call recording Id.
     * 
     * @return the recordingId value.
     */
    @Generated
    public String getRecordingId() {
        return this.recordingId;
    }

    /**
     * Get the callConnectionId property: Call connection ID.
     * 
     * @return the callConnectionId value.
     */
    @Generated
    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    /**
     * Set the callConnectionId property: Call connection ID.
     * 
     * @param callConnectionId the callConnectionId value to set.
     * @return the StartRecordingFailed object itself.
     */
    @Generated
    public StartRecordingFailed setCallConnectionId(String callConnectionId) {
        this.callConnectionId = callConnectionId;
        return this;
    }

    /**
     * Get the serverCallId property: Server call ID.
     * 
     * @return the serverCallId value.
     */
    @Generated
    public String getServerCallId() {
        return this.serverCallId;
    }

    /**
     * Set the serverCallId property: Server call ID.
     * 
     * @param serverCallId the serverCallId value to set.
     * @return the StartRecordingFailed object itself.
     */
    @Generated
    public StartRecordingFailed setServerCallId(String serverCallId) {
        this.serverCallId = serverCallId;
        return this;
    }

    /**
     * Get the correlationId property: Correlation ID for event to call correlation. Also called ChainId for skype chain
     * ID.
     * 
     * @return the correlationId value.
     */
    @Generated
    public String getCorrelationId() {
        return this.correlationId;
    }

    /**
     * Set the correlationId property: Correlation ID for event to call correlation. Also called ChainId for skype chain
     * ID.
     * 
     * @param correlationId the correlationId value to set.
     * @return the StartRecordingFailed object itself.
     */
    @Generated
    public StartRecordingFailed setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    /**
     * Get the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @param operationContext the operationContext value to set.
     * @return the StartRecordingFailed object itself.
     */
    @Generated
    public StartRecordingFailed setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the resultInformation property: Contains the resulting SIP code, sub-code and message.
     * 
     * @return the resultInformation value.
     */
    @Generated
    public ResultInformation getResultInformation() {
        return this.resultInformation;
    }

    /**
     * Set the resultInformation property: Contains the resulting SIP code, sub-code and message.
     * 
     * @param resultInformation the resultInformation value to set.
     * @return the StartRecordingFailed object itself.
     */
    @Generated
    public StartRecordingFailed setResultInformation(ResultInformation resultInformation) {
        this.resultInformation = resultInformation;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("callConnectionId", this.callConnectionId);
        jsonWriter.writeStringField("serverCallId", this.serverCallId);
        jsonWriter.writeStringField("correlationId", this.correlationId);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeJsonField("resultInformation", this.resultInformation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StartRecordingFailed from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StartRecordingFailed if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StartRecordingFailed.
     */
    @Generated
    public static StartRecordingFailed fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StartRecordingFailed deserializedStartRecordingFailed = new StartRecordingFailed();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recordingId".equals(fieldName)) {
                    deserializedStartRecordingFailed.recordingId = reader.getString();
                } else if ("callConnectionId".equals(fieldName)) {
                    deserializedStartRecordingFailed.callConnectionId = reader.getString();
                } else if ("serverCallId".equals(fieldName)) {
                    deserializedStartRecordingFailed.serverCallId = reader.getString();
                } else if ("correlationId".equals(fieldName)) {
                    deserializedStartRecordingFailed.correlationId = reader.getString();
                } else if ("operationContext".equals(fieldName)) {
                    deserializedStartRecordingFailed.operationContext = reader.getString();
                } else if ("resultInformation".equals(fieldName)) {
                    deserializedStartRecordingFailed.resultInformation = ResultInformation.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStartRecordingFailed;
        });
    }
}
