// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The StartMediaStreamingRequest model.
 */
@Fluent
public final class StartMediaStreamingRequest implements JsonSerializable<StartMediaStreamingRequest> {
    /*
     * Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     */
    @Generated
    private String operationCallbackUri;

    /*
     * The value to identify context of the operation.
     */
    @Generated
    private String operationContext;

    /**
     * Creates an instance of StartMediaStreamingRequest class.
     */
    @Generated
    public StartMediaStreamingRequest() {
    }

    /**
     * Get the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @return the operationCallbackUri value.
     */
    @Generated
    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    /**
     * Set the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @param operationCallbackUri the operationCallbackUri value to set.
     * @return the StartMediaStreamingRequest object itself.
     */
    @Generated
    public StartMediaStreamingRequest setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    /**
     * Get the operationContext property: The value to identify context of the operation.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: The value to identify context of the operation.
     * 
     * @param operationContext the operationContext value to set.
     * @return the StartMediaStreamingRequest object itself.
     */
    @Generated
    public StartMediaStreamingRequest setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StartMediaStreamingRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StartMediaStreamingRequest if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StartMediaStreamingRequest.
     */
    @Generated
    public static StartMediaStreamingRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StartMediaStreamingRequest deserializedStartMediaStreamingRequest = new StartMediaStreamingRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operationCallbackUri".equals(fieldName)) {
                    deserializedStartMediaStreamingRequest.operationCallbackUri = reader.getString();
                } else if ("operationContext".equals(fieldName)) {
                    deserializedStartMediaStreamingRequest.operationContext = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStartMediaStreamingRequest;
        });
    }
}
