// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request payload for holding participant from the call.
 */
@Fluent
public final class StartHoldMusicRequestInternal implements JsonSerializable<StartHoldMusicRequestInternal> {
    /*
     * Participant to be held from the call.
     */
    private CommunicationIdentifierModel targetParticipant;

    /*
     * Prompt to play while in hold.
     */
    private PlaySourceInternal playSourceInfo;

    /*
     * Used by customers when calling mid-call actions to correlate the request to the response event.
     */
    private String operationContext;

    /*
     * Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     */
    private String operationCallbackUri;

    /**
     * Creates an instance of StartHoldMusicRequestInternal class.
     */
    public StartHoldMusicRequestInternal() {
    }

    /**
     * Get the targetParticipant property: Participant to be held from the call.
     * 
     * @return the targetParticipant value.
     */
    public CommunicationIdentifierModel getTargetParticipant() {
        return this.targetParticipant;
    }

    /**
     * Set the targetParticipant property: Participant to be held from the call.
     * 
     * @param targetParticipant the targetParticipant value to set.
     * @return the StartHoldMusicRequestInternal object itself.
     */
    public StartHoldMusicRequestInternal setTargetParticipant(CommunicationIdentifierModel targetParticipant) {
        this.targetParticipant = targetParticipant;
        return this;
    }

    /**
     * Get the playSourceInfo property: Prompt to play while in hold.
     * 
     * @return the playSourceInfo value.
     */
    public PlaySourceInternal getPlaySourceInfo() {
        return this.playSourceInfo;
    }

    /**
     * Set the playSourceInfo property: Prompt to play while in hold.
     * 
     * @param playSourceInfo the playSourceInfo value to set.
     * @return the StartHoldMusicRequestInternal object itself.
     */
    public StartHoldMusicRequestInternal setPlaySourceInfo(PlaySourceInternal playSourceInfo) {
        this.playSourceInfo = playSourceInfo;
        return this;
    }

    /**
     * Get the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @return the operationContext value.
     */
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @param operationContext the operationContext value to set.
     * @return the StartHoldMusicRequestInternal object itself.
     */
    public StartHoldMusicRequestInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @return the operationCallbackUri value.
     */
    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    /**
     * Set the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @param operationCallbackUri the operationCallbackUri value to set.
     * @return the StartHoldMusicRequestInternal object itself.
     */
    public StartHoldMusicRequestInternal setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("targetParticipant", this.targetParticipant);
        jsonWriter.writeJsonField("playSourceInfo", this.playSourceInfo);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StartHoldMusicRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StartHoldMusicRequestInternal if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StartHoldMusicRequestInternal.
     */
    public static StartHoldMusicRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StartHoldMusicRequestInternal deserializedStartHoldMusicRequestInternal
                = new StartHoldMusicRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetParticipant".equals(fieldName)) {
                    deserializedStartHoldMusicRequestInternal.targetParticipant
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("playSourceInfo".equals(fieldName)) {
                    deserializedStartHoldMusicRequestInternal.playSourceInfo = PlaySourceInternal.fromJson(reader);
                } else if ("operationContext".equals(fieldName)) {
                    deserializedStartHoldMusicRequestInternal.operationContext = reader.getString();
                } else if ("operationCallbackUri".equals(fieldName)) {
                    deserializedStartHoldMusicRequestInternal.operationCallbackUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStartHoldMusicRequestInternal;
        });
    }
}
