// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The request payload start for call recording operation with call locator.
 */
@Fluent
public final class StartCallRecordingRequestInternal implements JsonSerializable<StartCallRecordingRequestInternal> {
    /*
     * The call locator. (Only one of callLocator or callConnectionId to be used)
     */
    @Generated
    private CallLocatorInternal callLocator;

    /*
     * The call connection Id. (Only one of callLocator or callConnectionId to be used)
     */
    @Generated
    private String callConnectionId;

    /*
     * The uri to send notifications to.
     */
    @Generated
    private String recordingStateCallbackUri;

    /*
     * The content type of call recording.
     */
    @Generated
    private RecordingContentInternal recordingContentType;

    /*
     * The channel type of call recording.
     */
    @Generated
    private RecordingChannelInternal recordingChannelType;

    /*
     * The format type of call recording.
     */
    @Generated
    private RecordingFormatInternal recordingFormatType;

    /*
     * The sequential order in which audio channels are assigned to participants in the unmixed recording.
     * When 'recordingChannelType' is set to 'unmixed' and `audioChannelParticipantOrdering is not specified,
     * the audio channel to participant mapping will be automatically assigned based on the order in which participant
     * first audio was detected. Channel to participant mapping details can be found in the metadata of the recording.
     */
    @Generated
    private List<CommunicationIdentifierModel> audioChannelParticipantOrdering;

    /*
     * The channel affinity of call recording
     * When 'recordingChannelType' is set to 'unmixed', if channelAffinity is not specified, 'channel' will be
     * automatically assigned.
     * Channel-Participant mapping details can be found in the metadata of the recording.
     * ///
     */
    @Generated
    private List<ChannelAffinityInternal> channelAffinity;

    /*
     * When set to true will start recording in Pause mode, which can be resumed.
     */
    @Generated
    private Boolean pauseOnStart;

    /*
     * Optional property to specify location where recording will be stored
     */
    @Generated
    private RecordingStorageInternal externalStorage;

    /**
     * Creates an instance of StartCallRecordingRequestInternal class.
     */
    @Generated
    public StartCallRecordingRequestInternal() {
    }

    /**
     * Get the callLocator property: The call locator. (Only one of callLocator or callConnectionId to be used).
     * 
     * @return the callLocator value.
     */
    @Generated
    public CallLocatorInternal getCallLocator() {
        return this.callLocator;
    }

    /**
     * Set the callLocator property: The call locator. (Only one of callLocator or callConnectionId to be used).
     * 
     * @param callLocator the callLocator value to set.
     * @return the StartCallRecordingRequestInternal object itself.
     */
    @Generated
    public StartCallRecordingRequestInternal setCallLocator(CallLocatorInternal callLocator) {
        this.callLocator = callLocator;
        return this;
    }

    /**
     * Get the callConnectionId property: The call connection Id. (Only one of callLocator or callConnectionId to be
     * used).
     * 
     * @return the callConnectionId value.
     */
    @Generated
    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    /**
     * Set the callConnectionId property: The call connection Id. (Only one of callLocator or callConnectionId to be
     * used).
     * 
     * @param callConnectionId the callConnectionId value to set.
     * @return the StartCallRecordingRequestInternal object itself.
     */
    @Generated
    public StartCallRecordingRequestInternal setCallConnectionId(String callConnectionId) {
        this.callConnectionId = callConnectionId;
        return this;
    }

    /**
     * Get the recordingStateCallbackUri property: The uri to send notifications to.
     * 
     * @return the recordingStateCallbackUri value.
     */
    @Generated
    public String getRecordingStateCallbackUri() {
        return this.recordingStateCallbackUri;
    }

    /**
     * Set the recordingStateCallbackUri property: The uri to send notifications to.
     * 
     * @param recordingStateCallbackUri the recordingStateCallbackUri value to set.
     * @return the StartCallRecordingRequestInternal object itself.
     */
    @Generated
    public StartCallRecordingRequestInternal setRecordingStateCallbackUri(String recordingStateCallbackUri) {
        this.recordingStateCallbackUri = recordingStateCallbackUri;
        return this;
    }

    /**
     * Get the recordingContentType property: The content type of call recording.
     * 
     * @return the recordingContentType value.
     */
    @Generated
    public RecordingContentInternal getRecordingContentType() {
        return this.recordingContentType;
    }

    /**
     * Set the recordingContentType property: The content type of call recording.
     * 
     * @param recordingContentType the recordingContentType value to set.
     * @return the StartCallRecordingRequestInternal object itself.
     */
    @Generated
    public StartCallRecordingRequestInternal setRecordingContentType(RecordingContentInternal recordingContentType) {
        this.recordingContentType = recordingContentType;
        return this;
    }

    /**
     * Get the recordingChannelType property: The channel type of call recording.
     * 
     * @return the recordingChannelType value.
     */
    @Generated
    public RecordingChannelInternal getRecordingChannelType() {
        return this.recordingChannelType;
    }

    /**
     * Set the recordingChannelType property: The channel type of call recording.
     * 
     * @param recordingChannelType the recordingChannelType value to set.
     * @return the StartCallRecordingRequestInternal object itself.
     */
    @Generated
    public StartCallRecordingRequestInternal setRecordingChannelType(RecordingChannelInternal recordingChannelType) {
        this.recordingChannelType = recordingChannelType;
        return this;
    }

    /**
     * Get the recordingFormatType property: The format type of call recording.
     * 
     * @return the recordingFormatType value.
     */
    @Generated
    public RecordingFormatInternal getRecordingFormatType() {
        return this.recordingFormatType;
    }

    /**
     * Set the recordingFormatType property: The format type of call recording.
     * 
     * @param recordingFormatType the recordingFormatType value to set.
     * @return the StartCallRecordingRequestInternal object itself.
     */
    @Generated
    public StartCallRecordingRequestInternal setRecordingFormatType(RecordingFormatInternal recordingFormatType) {
        this.recordingFormatType = recordingFormatType;
        return this;
    }

    /**
     * Get the audioChannelParticipantOrdering property: The sequential order in which audio channels are assigned to
     * participants in the unmixed recording.
     * When 'recordingChannelType' is set to 'unmixed' and `audioChannelParticipantOrdering is not specified,
     * the audio channel to participant mapping will be automatically assigned based on the order in which participant
     * first audio was detected. Channel to participant mapping details can be found in the metadata of the recording.
     * 
     * @return the audioChannelParticipantOrdering value.
     */
    @Generated
    public List<CommunicationIdentifierModel> getAudioChannelParticipantOrdering() {
        return this.audioChannelParticipantOrdering;
    }

    /**
     * Set the audioChannelParticipantOrdering property: The sequential order in which audio channels are assigned to
     * participants in the unmixed recording.
     * When 'recordingChannelType' is set to 'unmixed' and `audioChannelParticipantOrdering is not specified,
     * the audio channel to participant mapping will be automatically assigned based on the order in which participant
     * first audio was detected. Channel to participant mapping details can be found in the metadata of the recording.
     * 
     * @param audioChannelParticipantOrdering the audioChannelParticipantOrdering value to set.
     * @return the StartCallRecordingRequestInternal object itself.
     */
    @Generated
    public StartCallRecordingRequestInternal
        setAudioChannelParticipantOrdering(List<CommunicationIdentifierModel> audioChannelParticipantOrdering) {
        this.audioChannelParticipantOrdering = audioChannelParticipantOrdering;
        return this;
    }

    /**
     * Get the channelAffinity property: The channel affinity of call recording
     * When 'recordingChannelType' is set to 'unmixed', if channelAffinity is not specified, 'channel' will be
     * automatically assigned.
     * Channel-Participant mapping details can be found in the metadata of the recording.
     * ///.
     * 
     * @return the channelAffinity value.
     */
    @Generated
    public List<ChannelAffinityInternal> getChannelAffinity() {
        return this.channelAffinity;
    }

    /**
     * Set the channelAffinity property: The channel affinity of call recording
     * When 'recordingChannelType' is set to 'unmixed', if channelAffinity is not specified, 'channel' will be
     * automatically assigned.
     * Channel-Participant mapping details can be found in the metadata of the recording.
     * ///.
     * 
     * @param channelAffinity the channelAffinity value to set.
     * @return the StartCallRecordingRequestInternal object itself.
     */
    @Generated
    public StartCallRecordingRequestInternal setChannelAffinity(List<ChannelAffinityInternal> channelAffinity) {
        this.channelAffinity = channelAffinity;
        return this;
    }

    /**
     * Get the pauseOnStart property: When set to true will start recording in Pause mode, which can be resumed.
     * 
     * @return the pauseOnStart value.
     */
    @Generated
    public Boolean isPauseOnStart() {
        return this.pauseOnStart;
    }

    /**
     * Set the pauseOnStart property: When set to true will start recording in Pause mode, which can be resumed.
     * 
     * @param pauseOnStart the pauseOnStart value to set.
     * @return the StartCallRecordingRequestInternal object itself.
     */
    @Generated
    public StartCallRecordingRequestInternal setPauseOnStart(Boolean pauseOnStart) {
        this.pauseOnStart = pauseOnStart;
        return this;
    }

    /**
     * Get the externalStorage property: Optional property to specify location where recording will be stored.
     * 
     * @return the externalStorage value.
     */
    @Generated
    public RecordingStorageInternal getExternalStorage() {
        return this.externalStorage;
    }

    /**
     * Set the externalStorage property: Optional property to specify location where recording will be stored.
     * 
     * @param externalStorage the externalStorage value to set.
     * @return the StartCallRecordingRequestInternal object itself.
     */
    @Generated
    public StartCallRecordingRequestInternal setExternalStorage(RecordingStorageInternal externalStorage) {
        this.externalStorage = externalStorage;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("callLocator", this.callLocator);
        jsonWriter.writeStringField("callConnectionId", this.callConnectionId);
        jsonWriter.writeStringField("recordingStateCallbackUri", this.recordingStateCallbackUri);
        jsonWriter.writeStringField("recordingContentType",
            this.recordingContentType == null ? null : this.recordingContentType.toString());
        jsonWriter.writeStringField("recordingChannelType",
            this.recordingChannelType == null ? null : this.recordingChannelType.toString());
        jsonWriter.writeStringField("recordingFormatType",
            this.recordingFormatType == null ? null : this.recordingFormatType.toString());
        jsonWriter.writeArrayField("audioChannelParticipantOrdering", this.audioChannelParticipantOrdering,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("channelAffinity", this.channelAffinity,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("pauseOnStart", this.pauseOnStart);
        jsonWriter.writeJsonField("externalStorage", this.externalStorage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StartCallRecordingRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StartCallRecordingRequestInternal if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StartCallRecordingRequestInternal.
     */
    @Generated
    public static StartCallRecordingRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StartCallRecordingRequestInternal deserializedStartCallRecordingRequestInternal
                = new StartCallRecordingRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("callLocator".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.callLocator = CallLocatorInternal.fromJson(reader);
                } else if ("callConnectionId".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.callConnectionId = reader.getString();
                } else if ("recordingStateCallbackUri".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.recordingStateCallbackUri = reader.getString();
                } else if ("recordingContentType".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.recordingContentType
                        = RecordingContentInternal.fromString(reader.getString());
                } else if ("recordingChannelType".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.recordingChannelType
                        = RecordingChannelInternal.fromString(reader.getString());
                } else if ("recordingFormatType".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.recordingFormatType
                        = RecordingFormatInternal.fromString(reader.getString());
                } else if ("audioChannelParticipantOrdering".equals(fieldName)) {
                    List<CommunicationIdentifierModel> audioChannelParticipantOrdering
                        = reader.readArray(reader1 -> CommunicationIdentifierModel.fromJson(reader1));
                    deserializedStartCallRecordingRequestInternal.audioChannelParticipantOrdering
                        = audioChannelParticipantOrdering;
                } else if ("channelAffinity".equals(fieldName)) {
                    List<ChannelAffinityInternal> channelAffinity
                        = reader.readArray(reader1 -> ChannelAffinityInternal.fromJson(reader1));
                    deserializedStartCallRecordingRequestInternal.channelAffinity = channelAffinity;
                } else if ("pauseOnStart".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.pauseOnStart
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("externalStorage".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.externalStorage
                        = RecordingStorageInternal.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStartCallRecordingRequestInternal;
        });
    }
}
