// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SsmlSourceInternal model.
 */
@Fluent
public final class SsmlSourceInternal implements JsonSerializable<SsmlSourceInternal> {
    /*
     * Ssml string for the cognitive service to be played
     */
    @Generated
    private String ssmlText;

    /*
     * Endpoint where the custom voice was deployed.
     */
    @Generated
    private String customVoiceEndpointId;

    /**
     * Creates an instance of SsmlSourceInternal class.
     */
    @Generated
    public SsmlSourceInternal() {
    }

    /**
     * Get the ssmlText property: Ssml string for the cognitive service to be played.
     * 
     * @return the ssmlText value.
     */
    @Generated
    public String getSsmlText() {
        return this.ssmlText;
    }

    /**
     * Set the ssmlText property: Ssml string for the cognitive service to be played.
     * 
     * @param ssmlText the ssmlText value to set.
     * @return the SsmlSourceInternal object itself.
     */
    @Generated
    public SsmlSourceInternal setSsmlText(String ssmlText) {
        this.ssmlText = ssmlText;
        return this;
    }

    /**
     * Get the customVoiceEndpointId property: Endpoint where the custom voice was deployed.
     * 
     * @return the customVoiceEndpointId value.
     */
    @Generated
    public String getCustomVoiceEndpointId() {
        return this.customVoiceEndpointId;
    }

    /**
     * Set the customVoiceEndpointId property: Endpoint where the custom voice was deployed.
     * 
     * @param customVoiceEndpointId the customVoiceEndpointId value to set.
     * @return the SsmlSourceInternal object itself.
     */
    @Generated
    public SsmlSourceInternal setCustomVoiceEndpointId(String customVoiceEndpointId) {
        this.customVoiceEndpointId = customVoiceEndpointId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ssmlText", this.ssmlText);
        jsonWriter.writeStringField("customVoiceEndpointId", this.customVoiceEndpointId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SsmlSourceInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SsmlSourceInternal if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SsmlSourceInternal.
     */
    @Generated
    public static SsmlSourceInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SsmlSourceInternal deserializedSsmlSourceInternal = new SsmlSourceInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ssmlText".equals(fieldName)) {
                    deserializedSsmlSourceInternal.ssmlText = reader.getString();
                } else if ("customVoiceEndpointId".equals(fieldName)) {
                    deserializedSsmlSourceInternal.customVoiceEndpointId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSsmlSourceInternal;
        });
    }
}
