// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The speech status as a result.
 */
@Fluent
public final class SpeechResultInternal implements JsonSerializable<SpeechResultInternal> {
    /*
     * The recognized speech in string.
     */
    @Generated
    private String speech;

    /*
     * The confidence level of the recognized speech, if available, ranges from 0.0 to 1.0.
     */
    @Generated
    private Double confidence;

    /**
     * Creates an instance of SpeechResultInternal class.
     */
    @Generated
    public SpeechResultInternal() {
    }

    /**
     * Get the speech property: The recognized speech in string.
     * 
     * @return the speech value.
     */
    @Generated
    public String getSpeech() {
        return this.speech;
    }

    /**
     * Set the speech property: The recognized speech in string.
     * 
     * @param speech the speech value to set.
     * @return the SpeechResultInternal object itself.
     */
    @Generated
    public SpeechResultInternal setSpeech(String speech) {
        this.speech = speech;
        return this;
    }

    /**
     * Get the confidence property: The confidence level of the recognized speech, if available, ranges from 0.0 to 1.0.
     * 
     * @return the confidence value.
     */
    @Generated
    public Double getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: The confidence level of the recognized speech, if available, ranges from 0.0 to 1.0.
     * 
     * @param confidence the confidence value to set.
     * @return the SpeechResultInternal object itself.
     */
    @Generated
    public SpeechResultInternal setConfidence(Double confidence) {
        this.confidence = confidence;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("speech", this.speech);
        jsonWriter.writeNumberField("confidence", this.confidence);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SpeechResultInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SpeechResultInternal if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SpeechResultInternal.
     */
    @Generated
    public static SpeechResultInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SpeechResultInternal deserializedSpeechResultInternal = new SpeechResultInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("speech".equals(fieldName)) {
                    deserializedSpeechResultInternal.speech = reader.getString();
                } else if ("confidence".equals(fieldName)) {
                    deserializedSpeechResultInternal.confidence = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSpeechResultInternal;
        });
    }
}
