// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The SendDtmfTonesRequestInternal model.
 */
@Fluent
public final class SendDtmfTonesRequestInternal implements JsonSerializable<SendDtmfTonesRequestInternal> {
    /*
     * List of tones to be sent to target participant.
     */
    @Generated
    private List<DtmfToneInternal> tones;

    /*
     * Target participant of send Dtmf tones.
     */
    @Generated
    private CommunicationIdentifierModel targetParticipant;

    /*
     * The value to identify context of the operation.
     */
    @Generated
    private String operationContext;

    /*
     * Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     */
    @Generated
    private String operationCallbackUri;

    /**
     * Creates an instance of SendDtmfTonesRequestInternal class.
     */
    @Generated
    public SendDtmfTonesRequestInternal() {
    }

    /**
     * Get the tones property: List of tones to be sent to target participant.
     * 
     * @return the tones value.
     */
    @Generated
    public List<DtmfToneInternal> getTones() {
        return this.tones;
    }

    /**
     * Set the tones property: List of tones to be sent to target participant.
     * 
     * @param tones the tones value to set.
     * @return the SendDtmfTonesRequestInternal object itself.
     */
    @Generated
    public SendDtmfTonesRequestInternal setTones(List<DtmfToneInternal> tones) {
        this.tones = tones;
        return this;
    }

    /**
     * Get the targetParticipant property: Target participant of send Dtmf tones.
     * 
     * @return the targetParticipant value.
     */
    @Generated
    public CommunicationIdentifierModel getTargetParticipant() {
        return this.targetParticipant;
    }

    /**
     * Set the targetParticipant property: Target participant of send Dtmf tones.
     * 
     * @param targetParticipant the targetParticipant value to set.
     * @return the SendDtmfTonesRequestInternal object itself.
     */
    @Generated
    public SendDtmfTonesRequestInternal setTargetParticipant(CommunicationIdentifierModel targetParticipant) {
        this.targetParticipant = targetParticipant;
        return this;
    }

    /**
     * Get the operationContext property: The value to identify context of the operation.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: The value to identify context of the operation.
     * 
     * @param operationContext the operationContext value to set.
     * @return the SendDtmfTonesRequestInternal object itself.
     */
    @Generated
    public SendDtmfTonesRequestInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @return the operationCallbackUri value.
     */
    @Generated
    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    /**
     * Set the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @param operationCallbackUri the operationCallbackUri value to set.
     * @return the SendDtmfTonesRequestInternal object itself.
     */
    @Generated
    public SendDtmfTonesRequestInternal setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tones", this.tones,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("targetParticipant", this.targetParticipant);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SendDtmfTonesRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SendDtmfTonesRequestInternal if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SendDtmfTonesRequestInternal.
     */
    @Generated
    public static SendDtmfTonesRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SendDtmfTonesRequestInternal deserializedSendDtmfTonesRequestInternal = new SendDtmfTonesRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tones".equals(fieldName)) {
                    List<DtmfToneInternal> tones
                        = reader.readArray(reader1 -> DtmfToneInternal.fromString(reader1.getString()));
                    deserializedSendDtmfTonesRequestInternal.tones = tones;
                } else if ("targetParticipant".equals(fieldName)) {
                    deserializedSendDtmfTonesRequestInternal.targetParticipant
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("operationContext".equals(fieldName)) {
                    deserializedSendDtmfTonesRequestInternal.operationContext = reader.getString();
                } else if ("operationCallbackUri".equals(fieldName)) {
                    deserializedSendDtmfTonesRequestInternal.operationCallbackUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSendDtmfTonesRequestInternal;
        });
    }
}
