// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResultInformation model.
 */
@Fluent
public final class ResultInformation implements JsonSerializable<ResultInformation> {
    /*
     * Code of the current result. This can be helpful to Call Automation team to troubleshoot the issue if this result
     * was unexpected.
     */
    @Generated
    private Integer code;

    /*
     * Subcode of the current result. This can be helpful to Call Automation team to troubleshoot the issue if this
     * result was unexpected.
     */
    @Generated
    private Integer subCode;

    /*
     * Detail message that describes the current result.
     */
    @Generated
    private String message;

    /**
     * Creates an instance of ResultInformation class.
     */
    @Generated
    public ResultInformation() {
    }

    /**
     * Get the code property: Code of the current result. This can be helpful to Call Automation team to troubleshoot
     * the issue if this result was unexpected.
     * 
     * @return the code value.
     */
    @Generated
    public Integer getCode() {
        return this.code;
    }

    /**
     * Set the code property: Code of the current result. This can be helpful to Call Automation team to troubleshoot
     * the issue if this result was unexpected.
     * 
     * @param code the code value to set.
     * @return the ResultInformation object itself.
     */
    @Generated
    public ResultInformation setCode(Integer code) {
        this.code = code;
        return this;
    }

    /**
     * Get the subCode property: Subcode of the current result. This can be helpful to Call Automation team to
     * troubleshoot the issue if this result was unexpected.
     * 
     * @return the subCode value.
     */
    @Generated
    public Integer getSubCode() {
        return this.subCode;
    }

    /**
     * Set the subCode property: Subcode of the current result. This can be helpful to Call Automation team to
     * troubleshoot the issue if this result was unexpected.
     * 
     * @param subCode the subCode value to set.
     * @return the ResultInformation object itself.
     */
    @Generated
    public ResultInformation setSubCode(Integer subCode) {
        this.subCode = subCode;
        return this;
    }

    /**
     * Get the message property: Detail message that describes the current result.
     * 
     * @return the message value.
     */
    @Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * Set the message property: Detail message that describes the current result.
     * 
     * @param message the message value to set.
     * @return the ResultInformation object itself.
     */
    @Generated
    public ResultInformation setMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("code", this.code);
        jsonWriter.writeNumberField("subCode", this.subCode);
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResultInformation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResultInformation if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResultInformation.
     */
    @Generated
    public static ResultInformation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResultInformation deserializedResultInformation = new ResultInformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedResultInformation.code = reader.getNullable(JsonReader::getInt);
                } else if ("subCode".equals(fieldName)) {
                    deserializedResultInformation.subCode = reader.getNullable(JsonReader::getInt);
                } else if ("message".equals(fieldName)) {
                    deserializedResultInformation.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResultInformation;
        });
    }
}
