// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The remove participant by identifier request.
 */
@Fluent
public final class RemoveParticipantRequestInternal implements JsonSerializable<RemoveParticipantRequestInternal> {
    /*
     * The participants to be removed from the call.
     */
    @Generated
    private CommunicationIdentifierModel participantToRemove;

    /*
     * Used by customers when calling mid-call actions to correlate the request to the response event.
     */
    @Generated
    private String operationContext;

    /*
     * Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     */
    @Generated
    private String operationCallbackUri;

    /**
     * Creates an instance of RemoveParticipantRequestInternal class.
     */
    @Generated
    public RemoveParticipantRequestInternal() {
    }

    /**
     * Get the participantToRemove property: The participants to be removed from the call.
     * 
     * @return the participantToRemove value.
     */
    @Generated
    public CommunicationIdentifierModel getParticipantToRemove() {
        return this.participantToRemove;
    }

    /**
     * Set the participantToRemove property: The participants to be removed from the call.
     * 
     * @param participantToRemove the participantToRemove value to set.
     * @return the RemoveParticipantRequestInternal object itself.
     */
    @Generated
    public RemoveParticipantRequestInternal setParticipantToRemove(CommunicationIdentifierModel participantToRemove) {
        this.participantToRemove = participantToRemove;
        return this;
    }

    /**
     * Get the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @param operationContext the operationContext value to set.
     * @return the RemoveParticipantRequestInternal object itself.
     */
    @Generated
    public RemoveParticipantRequestInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @return the operationCallbackUri value.
     */
    @Generated
    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    /**
     * Set the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @param operationCallbackUri the operationCallbackUri value to set.
     * @return the RemoveParticipantRequestInternal object itself.
     */
    @Generated
    public RemoveParticipantRequestInternal setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("participantToRemove", this.participantToRemove);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RemoveParticipantRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RemoveParticipantRequestInternal if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RemoveParticipantRequestInternal.
     */
    @Generated
    public static RemoveParticipantRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RemoveParticipantRequestInternal deserializedRemoveParticipantRequestInternal
                = new RemoveParticipantRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("participantToRemove".equals(fieldName)) {
                    deserializedRemoveParticipantRequestInternal.participantToRemove
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("operationContext".equals(fieldName)) {
                    deserializedRemoveParticipantRequestInternal.operationContext = reader.getString();
                } else if ("operationCallbackUri".equals(fieldName)) {
                    deserializedRemoveParticipantRequestInternal.operationCallbackUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRemoveParticipantRequestInternal;
        });
    }
}
