// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The failed to remove participant event.
 */
@Fluent
public final class RemoveParticipantFailed implements JsonSerializable<RemoveParticipantFailed> {
    /*
     * Call connection ID.
     */
    @Generated
    private String callConnectionId;

    /*
     * Server call ID.
     */
    @Generated
    private String serverCallId;

    /*
     * Correlation ID for event to call correlation. Also called ChainId for skype chain ID.
     */
    @Generated
    private String correlationId;

    /*
     * Used by customers when calling mid-call actions to correlate the request to the response event.
     */
    @Generated
    private String operationContext;

    /*
     * Contains the resulting SIP code, sub-code and message.
     */
    @Generated
    private ResultInformation resultInformation;

    /*
     * Participant
     */
    @Generated
    private CommunicationIdentifierModel participant;

    /**
     * Creates an instance of RemoveParticipantFailed class.
     */
    @Generated
    public RemoveParticipantFailed() {
    }

    /**
     * Get the callConnectionId property: Call connection ID.
     * 
     * @return the callConnectionId value.
     */
    @Generated
    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    /**
     * Set the callConnectionId property: Call connection ID.
     * 
     * @param callConnectionId the callConnectionId value to set.
     * @return the RemoveParticipantFailed object itself.
     */
    @Generated
    public RemoveParticipantFailed setCallConnectionId(String callConnectionId) {
        this.callConnectionId = callConnectionId;
        return this;
    }

    /**
     * Get the serverCallId property: Server call ID.
     * 
     * @return the serverCallId value.
     */
    @Generated
    public String getServerCallId() {
        return this.serverCallId;
    }

    /**
     * Set the serverCallId property: Server call ID.
     * 
     * @param serverCallId the serverCallId value to set.
     * @return the RemoveParticipantFailed object itself.
     */
    @Generated
    public RemoveParticipantFailed setServerCallId(String serverCallId) {
        this.serverCallId = serverCallId;
        return this;
    }

    /**
     * Get the correlationId property: Correlation ID for event to call correlation. Also called ChainId for skype chain
     * ID.
     * 
     * @return the correlationId value.
     */
    @Generated
    public String getCorrelationId() {
        return this.correlationId;
    }

    /**
     * Set the correlationId property: Correlation ID for event to call correlation. Also called ChainId for skype chain
     * ID.
     * 
     * @param correlationId the correlationId value to set.
     * @return the RemoveParticipantFailed object itself.
     */
    @Generated
    public RemoveParticipantFailed setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    /**
     * Get the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @param operationContext the operationContext value to set.
     * @return the RemoveParticipantFailed object itself.
     */
    @Generated
    public RemoveParticipantFailed setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the resultInformation property: Contains the resulting SIP code, sub-code and message.
     * 
     * @return the resultInformation value.
     */
    @Generated
    public ResultInformation getResultInformation() {
        return this.resultInformation;
    }

    /**
     * Set the resultInformation property: Contains the resulting SIP code, sub-code and message.
     * 
     * @param resultInformation the resultInformation value to set.
     * @return the RemoveParticipantFailed object itself.
     */
    @Generated
    public RemoveParticipantFailed setResultInformation(ResultInformation resultInformation) {
        this.resultInformation = resultInformation;
        return this;
    }

    /**
     * Get the participant property: Participant.
     * 
     * @return the participant value.
     */
    @Generated
    public CommunicationIdentifierModel getParticipant() {
        return this.participant;
    }

    /**
     * Set the participant property: Participant.
     * 
     * @param participant the participant value to set.
     * @return the RemoveParticipantFailed object itself.
     */
    @Generated
    public RemoveParticipantFailed setParticipant(CommunicationIdentifierModel participant) {
        this.participant = participant;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("callConnectionId", this.callConnectionId);
        jsonWriter.writeStringField("serverCallId", this.serverCallId);
        jsonWriter.writeStringField("correlationId", this.correlationId);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeJsonField("resultInformation", this.resultInformation);
        jsonWriter.writeJsonField("participant", this.participant);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RemoveParticipantFailed from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RemoveParticipantFailed if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RemoveParticipantFailed.
     */
    @Generated
    public static RemoveParticipantFailed fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RemoveParticipantFailed deserializedRemoveParticipantFailed = new RemoveParticipantFailed();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("callConnectionId".equals(fieldName)) {
                    deserializedRemoveParticipantFailed.callConnectionId = reader.getString();
                } else if ("serverCallId".equals(fieldName)) {
                    deserializedRemoveParticipantFailed.serverCallId = reader.getString();
                } else if ("correlationId".equals(fieldName)) {
                    deserializedRemoveParticipantFailed.correlationId = reader.getString();
                } else if ("operationContext".equals(fieldName)) {
                    deserializedRemoveParticipantFailed.operationContext = reader.getString();
                } else if ("resultInformation".equals(fieldName)) {
                    deserializedRemoveParticipantFailed.resultInformation = ResultInformation.fromJson(reader);
                } else if ("participant".equals(fieldName)) {
                    deserializedRemoveParticipantFailed.participant = CommunicationIdentifierModel.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRemoveParticipantFailed;
        });
    }
}
