// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request payload for redirecting the call.
 */
@Fluent
public final class RedirectCallRequestInternal implements JsonSerializable<RedirectCallRequestInternal> {
    /*
     * The context associated with the call.
     */
    @Generated
    private String incomingCallContext;

    /*
     * The target identity to redirect the call to.
     */
    @Generated
    private CommunicationIdentifierModel target;

    /**
     * Creates an instance of RedirectCallRequestInternal class.
     */
    @Generated
    public RedirectCallRequestInternal() {
    }

    /**
     * Get the incomingCallContext property: The context associated with the call.
     * 
     * @return the incomingCallContext value.
     */
    @Generated
    public String getIncomingCallContext() {
        return this.incomingCallContext;
    }

    /**
     * Set the incomingCallContext property: The context associated with the call.
     * 
     * @param incomingCallContext the incomingCallContext value to set.
     * @return the RedirectCallRequestInternal object itself.
     */
    @Generated
    public RedirectCallRequestInternal setIncomingCallContext(String incomingCallContext) {
        this.incomingCallContext = incomingCallContext;
        return this;
    }

    /**
     * Get the target property: The target identity to redirect the call to.
     * 
     * @return the target value.
     */
    @Generated
    public CommunicationIdentifierModel getTarget() {
        return this.target;
    }

    /**
     * Set the target property: The target identity to redirect the call to.
     * 
     * @param target the target value to set.
     * @return the RedirectCallRequestInternal object itself.
     */
    @Generated
    public RedirectCallRequestInternal setTarget(CommunicationIdentifierModel target) {
        this.target = target;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("incomingCallContext", this.incomingCallContext);
        jsonWriter.writeJsonField("target", this.target);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedirectCallRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedirectCallRequestInternal if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RedirectCallRequestInternal.
     */
    @Generated
    public static RedirectCallRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedirectCallRequestInternal deserializedRedirectCallRequestInternal = new RedirectCallRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("incomingCallContext".equals(fieldName)) {
                    deserializedRedirectCallRequestInternal.incomingCallContext = reader.getString();
                } else if ("target".equals(fieldName)) {
                    deserializedRedirectCallRequestInternal.target = CommunicationIdentifierModel.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedirectCallRequestInternal;
        });
    }
}
