// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Defines the kind of external storage.
 */
public final class RecordingStorageKind extends ExpandableStringEnum<RecordingStorageKind> {
    /**
     * Storage managed by Azure Communication Services.
     */
    public static final RecordingStorageKind AZURE_COMMUNICATION_SERVICES = fromString("AzureCommunicationServices");

    /**
     * Storage managed by provided Azure blob.
     */
    public static final RecordingStorageKind AZURE_BLOB_STORAGE = fromString("AzureBlobStorage");

    /**
     * Creates a new instance of RecordingStorageKind value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RecordingStorageKind() {
    }

    /**
     * Creates or finds a RecordingStorageKind from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RecordingStorageKind.
     */
    public static RecordingStorageKind fromString(String name) {
        return fromString(name, RecordingStorageKind.class);
    }

    /**
     * Gets known RecordingStorageKind values.
     * 
     * @return known RecordingStorageKind values.
     */
    public static Collection<RecordingStorageKind> values() {
        return values(RecordingStorageKind.class);
    }
}
