// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The RecordingStorageInternal model.
 */
@Fluent
public final class RecordingStorageInternal implements JsonSerializable<RecordingStorageInternal> {
    /*
     * Defines the kind of external storage
     */
    @Generated
    private RecordingStorageTypeInternal recordingStorageKind;

    /*
     * Uri of a container or a location within a container
     */
    @Generated
    private String recordingDestinationContainerUrl;

    /**
     * Creates an instance of RecordingStorageInternal class.
     */
    @Generated
    public RecordingStorageInternal() {
    }

    /**
     * Get the recordingStorageKind property: Defines the kind of external storage.
     * 
     * @return the recordingStorageKind value.
     */
    @Generated
    public RecordingStorageTypeInternal getRecordingStorageKind() {
        return this.recordingStorageKind;
    }

    /**
     * Set the recordingStorageKind property: Defines the kind of external storage.
     * 
     * @param recordingStorageKind the recordingStorageKind value to set.
     * @return the RecordingStorageInternal object itself.
     */
    @Generated
    public RecordingStorageInternal setRecordingStorageKind(RecordingStorageTypeInternal recordingStorageKind) {
        this.recordingStorageKind = recordingStorageKind;
        return this;
    }

    /**
     * Get the recordingDestinationContainerUrl property: Uri of a container or a location within a container.
     * 
     * @return the recordingDestinationContainerUrl value.
     */
    @Generated
    public String getRecordingDestinationContainerUrl() {
        return this.recordingDestinationContainerUrl;
    }

    /**
     * Set the recordingDestinationContainerUrl property: Uri of a container or a location within a container.
     * 
     * @param recordingDestinationContainerUrl the recordingDestinationContainerUrl value to set.
     * @return the RecordingStorageInternal object itself.
     */
    @Generated
    public RecordingStorageInternal setRecordingDestinationContainerUrl(String recordingDestinationContainerUrl) {
        this.recordingDestinationContainerUrl = recordingDestinationContainerUrl;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recordingStorageKind",
            this.recordingStorageKind == null ? null : this.recordingStorageKind.toString());
        jsonWriter.writeStringField("recordingDestinationContainerUrl", this.recordingDestinationContainerUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecordingStorageInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecordingStorageInternal if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RecordingStorageInternal.
     */
    @Generated
    public static RecordingStorageInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecordingStorageInternal deserializedRecordingStorageInternal = new RecordingStorageInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recordingStorageKind".equals(fieldName)) {
                    deserializedRecordingStorageInternal.recordingStorageKind
                        = RecordingStorageTypeInternal.fromString(reader.getString());
                } else if ("recordingDestinationContainerUrl".equals(fieldName)) {
                    deserializedRecordingStorageInternal.recordingDestinationContainerUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecordingStorageInternal;
        });
    }
}
