// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Recording result data.
 */
@Immutable
public final class RecordingResultResponse implements JsonSerializable<RecordingResultResponse> {
    /*
     * The recordingId property.
     */
    private String recordingId;

    /*
     * Container for chunks
     */
    private RecordingStorageInfo recordingStorageInfo;

    /*
     * The errors property.
     */
    private List<Error> errors;

    /*
     * The recordingStartTime property.
     */
    private OffsetDateTime recordingStartTime;

    /*
     * The recordingDurationMs property.
     */
    private Long recordingDurationMs;

    /*
     * The sessionEndReason property.
     */
    private CallSessionEndReason sessionEndReason;

    /*
     * The recordingExpirationTime property.
     */
    private OffsetDateTime recordingExpirationTime;

    /**
     * Creates an instance of RecordingResultResponse class.
     */
    public RecordingResultResponse() {
    }

    /**
     * Get the recordingId property: The recordingId property.
     * 
     * @return the recordingId value.
     */
    public String getRecordingId() {
        return this.recordingId;
    }

    /**
     * Get the recordingStorageInfo property: Container for chunks.
     * 
     * @return the recordingStorageInfo value.
     */
    public RecordingStorageInfo getRecordingStorageInfo() {
        return this.recordingStorageInfo;
    }

    /**
     * Get the errors property: The errors property.
     * 
     * @return the errors value.
     */
    public List<Error> getErrors() {
        return this.errors;
    }

    /**
     * Get the recordingStartTime property: The recordingStartTime property.
     * 
     * @return the recordingStartTime value.
     */
    public OffsetDateTime getRecordingStartTime() {
        return this.recordingStartTime;
    }

    /**
     * Get the recordingDurationMs property: The recordingDurationMs property.
     * 
     * @return the recordingDurationMs value.
     */
    public Long getRecordingDurationMs() {
        return this.recordingDurationMs;
    }

    /**
     * Get the sessionEndReason property: The sessionEndReason property.
     * 
     * @return the sessionEndReason value.
     */
    public CallSessionEndReason getSessionEndReason() {
        return this.sessionEndReason;
    }

    /**
     * Get the recordingExpirationTime property: The recordingExpirationTime property.
     * 
     * @return the recordingExpirationTime value.
     */
    public OffsetDateTime getRecordingExpirationTime() {
        return this.recordingExpirationTime;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecordingResultResponse from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecordingResultResponse if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecordingResultResponse.
     */
    public static RecordingResultResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecordingResultResponse deserializedRecordingResultResponse = new RecordingResultResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recordingId".equals(fieldName)) {
                    deserializedRecordingResultResponse.recordingId = reader.getString();
                } else if ("recordingStorageInfo".equals(fieldName)) {
                    deserializedRecordingResultResponse.recordingStorageInfo = RecordingStorageInfo.fromJson(reader);
                } else if ("errors".equals(fieldName)) {
                    List<Error> errors = reader.readArray(reader1 -> Error.fromJson(reader1));
                    deserializedRecordingResultResponse.errors = errors;
                } else if ("recordingStartTime".equals(fieldName)) {
                    deserializedRecordingResultResponse.recordingStartTime
                        = reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                } else if ("recordingDurationMs".equals(fieldName)) {
                    deserializedRecordingResultResponse.recordingDurationMs = reader.getNullable(JsonReader::getLong);
                } else if ("sessionEndReason".equals(fieldName)) {
                    deserializedRecordingResultResponse.sessionEndReason
                        = CallSessionEndReason.fromString(reader.getString());
                } else if ("recordingExpirationTime".equals(fieldName)) {
                    deserializedRecordingResultResponse.recordingExpirationTime
                        = reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecordingResultResponse;
        });
    }
}
