// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Recording chunk data.
 */
@Fluent
public final class RecordingChunkStorageInfo implements JsonSerializable<RecordingChunkStorageInfo> {
    /*
     * Chunk document id
     */
    private String documentId;

    /*
     * Chunks order in a multi chunk recording
     */
    private Integer index;

    /*
     * Reason this chunk ended
     */
    private ChunkEndReason endReason;

    /*
     * Location of the chunk
     */
    private String contentLocation;

    /*
     * Location of chunk metadata
     */
    private String metadataLocation;

    /*
     * Callback for deleting chunk
     */
    private String deleteLocation;

    /**
     * Creates an instance of RecordingChunkStorageInfo class.
     */
    public RecordingChunkStorageInfo() {
    }

    /**
     * Get the documentId property: Chunk document id.
     * 
     * @return the documentId value.
     */
    public String getDocumentId() {
        return this.documentId;
    }

    /**
     * Set the documentId property: Chunk document id.
     * 
     * @param documentId the documentId value to set.
     * @return the RecordingChunkStorageInfo object itself.
     */
    public RecordingChunkStorageInfo setDocumentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    /**
     * Get the index property: Chunks order in a multi chunk recording.
     * 
     * @return the index value.
     */
    public Integer getIndex() {
        return this.index;
    }

    /**
     * Set the index property: Chunks order in a multi chunk recording.
     * 
     * @param index the index value to set.
     * @return the RecordingChunkStorageInfo object itself.
     */
    public RecordingChunkStorageInfo setIndex(Integer index) {
        this.index = index;
        return this;
    }

    /**
     * Get the endReason property: Reason this chunk ended.
     * 
     * @return the endReason value.
     */
    public ChunkEndReason getEndReason() {
        return this.endReason;
    }

    /**
     * Set the endReason property: Reason this chunk ended.
     * 
     * @param endReason the endReason value to set.
     * @return the RecordingChunkStorageInfo object itself.
     */
    public RecordingChunkStorageInfo setEndReason(ChunkEndReason endReason) {
        this.endReason = endReason;
        return this;
    }

    /**
     * Get the contentLocation property: Location of the chunk.
     * 
     * @return the contentLocation value.
     */
    public String getContentLocation() {
        return this.contentLocation;
    }

    /**
     * Set the contentLocation property: Location of the chunk.
     * 
     * @param contentLocation the contentLocation value to set.
     * @return the RecordingChunkStorageInfo object itself.
     */
    public RecordingChunkStorageInfo setContentLocation(String contentLocation) {
        this.contentLocation = contentLocation;
        return this;
    }

    /**
     * Get the metadataLocation property: Location of chunk metadata.
     * 
     * @return the metadataLocation value.
     */
    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    /**
     * Set the metadataLocation property: Location of chunk metadata.
     * 
     * @param metadataLocation the metadataLocation value to set.
     * @return the RecordingChunkStorageInfo object itself.
     */
    public RecordingChunkStorageInfo setMetadataLocation(String metadataLocation) {
        this.metadataLocation = metadataLocation;
        return this;
    }

    /**
     * Get the deleteLocation property: Callback for deleting chunk.
     * 
     * @return the deleteLocation value.
     */
    public String getDeleteLocation() {
        return this.deleteLocation;
    }

    /**
     * Set the deleteLocation property: Callback for deleting chunk.
     * 
     * @param deleteLocation the deleteLocation value to set.
     * @return the RecordingChunkStorageInfo object itself.
     */
    public RecordingChunkStorageInfo setDeleteLocation(String deleteLocation) {
        this.deleteLocation = deleteLocation;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("documentId", this.documentId);
        jsonWriter.writeNumberField("index", this.index);
        jsonWriter.writeStringField("endReason", this.endReason == null ? null : this.endReason.toString());
        jsonWriter.writeStringField("contentLocation", this.contentLocation);
        jsonWriter.writeStringField("metadataLocation", this.metadataLocation);
        jsonWriter.writeStringField("deleteLocation", this.deleteLocation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecordingChunkStorageInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecordingChunkStorageInfo if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecordingChunkStorageInfo.
     */
    public static RecordingChunkStorageInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecordingChunkStorageInfo deserializedRecordingChunkStorageInfo = new RecordingChunkStorageInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("documentId".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.documentId = reader.getString();
                } else if ("index".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.index = reader.getNullable(JsonReader::getInt);
                } else if ("endReason".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.endReason = ChunkEndReason.fromString(reader.getString());
                } else if ("contentLocation".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.contentLocation = reader.getString();
                } else if ("metadataLocation".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.metadataLocation = reader.getString();
                } else if ("deleteLocation".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.deleteLocation = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecordingChunkStorageInfo;
        });
    }
}
