// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The RecognizeRequest model.
 */
@Fluent
public final class RecognizeRequest implements JsonSerializable<RecognizeRequest> {
    /*
     * Determines the type of the recognition.
     */
    @Generated
    private RecognizeInputTypeInternal recognizeInputType;

    /*
     * The source of the audio to be played for recognition.
     */
    @Generated
    private PlaySourceInternal playPrompt;

    /*
     * The source of the audio to be played for recognition.
     */
    @Generated
    private List<PlaySourceInternal> playPrompts;

    /*
     * If set recognize can barge into other existing queued-up/currently-processing requests.
     */
    @Generated
    private Boolean interruptCallMediaOperation;

    /*
     * Defines options for recognition.
     */
    @Generated
    private RecognizeOptionsInternal recognizeOptions;

    /*
     * The value to identify context of the operation.
     */
    @Generated
    private String operationContext;

    /*
     * Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     */
    @Generated
    private String operationCallbackUri;

    /**
     * Creates an instance of RecognizeRequest class.
     */
    @Generated
    public RecognizeRequest() {
    }

    /**
     * Get the recognizeInputType property: Determines the type of the recognition.
     * 
     * @return the recognizeInputType value.
     */
    @Generated
    public RecognizeInputTypeInternal getRecognizeInputType() {
        return this.recognizeInputType;
    }

    /**
     * Set the recognizeInputType property: Determines the type of the recognition.
     * 
     * @param recognizeInputType the recognizeInputType value to set.
     * @return the RecognizeRequest object itself.
     */
    @Generated
    public RecognizeRequest setRecognizeInputType(RecognizeInputTypeInternal recognizeInputType) {
        this.recognizeInputType = recognizeInputType;
        return this;
    }

    /**
     * Get the playPrompt property: The source of the audio to be played for recognition.
     * 
     * @return the playPrompt value.
     */
    @Generated
    public PlaySourceInternal getPlayPrompt() {
        return this.playPrompt;
    }

    /**
     * Set the playPrompt property: The source of the audio to be played for recognition.
     * 
     * @param playPrompt the playPrompt value to set.
     * @return the RecognizeRequest object itself.
     */
    @Generated
    public RecognizeRequest setPlayPrompt(PlaySourceInternal playPrompt) {
        this.playPrompt = playPrompt;
        return this;
    }

    /**
     * Get the playPrompts property: The source of the audio to be played for recognition.
     * 
     * @return the playPrompts value.
     */
    @Generated
    public List<PlaySourceInternal> getPlayPrompts() {
        return this.playPrompts;
    }

    /**
     * Set the playPrompts property: The source of the audio to be played for recognition.
     * 
     * @param playPrompts the playPrompts value to set.
     * @return the RecognizeRequest object itself.
     */
    @Generated
    public RecognizeRequest setPlayPrompts(List<PlaySourceInternal> playPrompts) {
        this.playPrompts = playPrompts;
        return this;
    }

    /**
     * Get the interruptCallMediaOperation property: If set recognize can barge into other existing
     * queued-up/currently-processing requests.
     * 
     * @return the interruptCallMediaOperation value.
     */
    @Generated
    public Boolean isInterruptCallMediaOperation() {
        return this.interruptCallMediaOperation;
    }

    /**
     * Set the interruptCallMediaOperation property: If set recognize can barge into other existing
     * queued-up/currently-processing requests.
     * 
     * @param interruptCallMediaOperation the interruptCallMediaOperation value to set.
     * @return the RecognizeRequest object itself.
     */
    @Generated
    public RecognizeRequest setInterruptCallMediaOperation(Boolean interruptCallMediaOperation) {
        this.interruptCallMediaOperation = interruptCallMediaOperation;
        return this;
    }

    /**
     * Get the recognizeOptions property: Defines options for recognition.
     * 
     * @return the recognizeOptions value.
     */
    @Generated
    public RecognizeOptionsInternal getRecognizeOptions() {
        return this.recognizeOptions;
    }

    /**
     * Set the recognizeOptions property: Defines options for recognition.
     * 
     * @param recognizeOptions the recognizeOptions value to set.
     * @return the RecognizeRequest object itself.
     */
    @Generated
    public RecognizeRequest setRecognizeOptions(RecognizeOptionsInternal recognizeOptions) {
        this.recognizeOptions = recognizeOptions;
        return this;
    }

    /**
     * Get the operationContext property: The value to identify context of the operation.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: The value to identify context of the operation.
     * 
     * @param operationContext the operationContext value to set.
     * @return the RecognizeRequest object itself.
     */
    @Generated
    public RecognizeRequest setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @return the operationCallbackUri value.
     */
    @Generated
    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    /**
     * Set the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @param operationCallbackUri the operationCallbackUri value to set.
     * @return the RecognizeRequest object itself.
     */
    @Generated
    public RecognizeRequest setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recognizeInputType",
            this.recognizeInputType == null ? null : this.recognizeInputType.toString());
        jsonWriter.writeJsonField("recognizeOptions", this.recognizeOptions);
        jsonWriter.writeJsonField("playPrompt", this.playPrompt);
        jsonWriter.writeArrayField("playPrompts", this.playPrompts, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("interruptCallMediaOperation", this.interruptCallMediaOperation);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecognizeRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecognizeRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RecognizeRequest.
     */
    @Generated
    public static RecognizeRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecognizeRequest deserializedRecognizeRequest = new RecognizeRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recognizeInputType".equals(fieldName)) {
                    deserializedRecognizeRequest.recognizeInputType
                        = RecognizeInputTypeInternal.fromString(reader.getString());
                } else if ("recognizeOptions".equals(fieldName)) {
                    deserializedRecognizeRequest.recognizeOptions = RecognizeOptionsInternal.fromJson(reader);
                } else if ("playPrompt".equals(fieldName)) {
                    deserializedRecognizeRequest.playPrompt = PlaySourceInternal.fromJson(reader);
                } else if ("playPrompts".equals(fieldName)) {
                    List<PlaySourceInternal> playPrompts
                        = reader.readArray(reader1 -> PlaySourceInternal.fromJson(reader1));
                    deserializedRecognizeRequest.playPrompts = playPrompts;
                } else if ("interruptCallMediaOperation".equals(fieldName)) {
                    deserializedRecognizeRequest.interruptCallMediaOperation
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("operationContext".equals(fieldName)) {
                    deserializedRecognizeRequest.operationContext = reader.getString();
                } else if ("operationCallbackUri".equals(fieldName)) {
                    deserializedRecognizeRequest.operationCallbackUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecognizeRequest;
        });
    }
}
