// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The RecognitionChoiceInternal model.
 */
@Fluent
public final class RecognitionChoiceInternal implements JsonSerializable<RecognitionChoiceInternal> {
    /*
     * Identifier for a given choice
     */
    @Generated
    private String label;

    /*
     * List of phrases to recognize
     */
    @Generated
    private List<String> phrases;

    /*
     * The tone property.
     */
    @Generated
    private DtmfToneInternal tone;

    /**
     * Creates an instance of RecognitionChoiceInternal class.
     */
    @Generated
    public RecognitionChoiceInternal() {
    }

    /**
     * Get the label property: Identifier for a given choice.
     * 
     * @return the label value.
     */
    @Generated
    public String getLabel() {
        return this.label;
    }

    /**
     * Set the label property: Identifier for a given choice.
     * 
     * @param label the label value to set.
     * @return the RecognitionChoiceInternal object itself.
     */
    @Generated
    public RecognitionChoiceInternal setLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the phrases property: List of phrases to recognize.
     * 
     * @return the phrases value.
     */
    @Generated
    public List<String> getPhrases() {
        return this.phrases;
    }

    /**
     * Set the phrases property: List of phrases to recognize.
     * 
     * @param phrases the phrases value to set.
     * @return the RecognitionChoiceInternal object itself.
     */
    @Generated
    public RecognitionChoiceInternal setPhrases(List<String> phrases) {
        this.phrases = phrases;
        return this;
    }

    /**
     * Get the tone property: The tone property.
     * 
     * @return the tone value.
     */
    @Generated
    public DtmfToneInternal getTone() {
        return this.tone;
    }

    /**
     * Set the tone property: The tone property.
     * 
     * @param tone the tone value to set.
     * @return the RecognitionChoiceInternal object itself.
     */
    @Generated
    public RecognitionChoiceInternal setTone(DtmfToneInternal tone) {
        this.tone = tone;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeArrayField("phrases", this.phrases, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("tone", this.tone == null ? null : this.tone.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecognitionChoiceInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecognitionChoiceInternal if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RecognitionChoiceInternal.
     */
    @Generated
    public static RecognitionChoiceInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecognitionChoiceInternal deserializedRecognitionChoiceInternal = new RecognitionChoiceInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("label".equals(fieldName)) {
                    deserializedRecognitionChoiceInternal.label = reader.getString();
                } else if ("phrases".equals(fieldName)) {
                    List<String> phrases = reader.readArray(reader1 -> reader1.getString());
                    deserializedRecognitionChoiceInternal.phrases = phrases;
                } else if ("tone".equals(fieldName)) {
                    deserializedRecognitionChoiceInternal.tone = DtmfToneInternal.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecognitionChoiceInternal;
        });
    }
}
