// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The result payload for muting participants from the call.
 */
@Fluent
public final class MuteParticipantsResultInternal implements JsonSerializable<MuteParticipantsResultInternal> {
    /*
     * The operation context provided by client.
     */
    @Generated
    private String operationContext;

    /**
     * Creates an instance of MuteParticipantsResultInternal class.
     */
    @Generated
    public MuteParticipantsResultInternal() {
    }

    /**
     * Get the operationContext property: The operation context provided by client.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: The operation context provided by client.
     * 
     * @param operationContext the operationContext value to set.
     * @return the MuteParticipantsResultInternal object itself.
     */
    @Generated
    public MuteParticipantsResultInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationContext", this.operationContext);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MuteParticipantsResultInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MuteParticipantsResultInternal if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MuteParticipantsResultInternal.
     */
    @Generated
    public static MuteParticipantsResultInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MuteParticipantsResultInternal deserializedMuteParticipantsResultInternal
                = new MuteParticipantsResultInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operationContext".equals(fieldName)) {
                    deserializedMuteParticipantsResultInternal.operationContext = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMuteParticipantsResultInternal;
        });
    }
}
