// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A Microsoft Teams user.
 */
@Fluent
public final class MicrosoftTeamsUserIdentifierModel implements JsonSerializable<MicrosoftTeamsUserIdentifierModel> {
    /*
     * The Id of the Microsoft Teams user. If not anonymous, this is the Entra ID object Id of the user.
     */
    @Generated
    private String userId;

    /*
     * True if the Microsoft Teams user is anonymous. By default false if missing.
     */
    @Generated
    private Boolean isAnonymous;

    /*
     * The cloud that the Microsoft Teams user belongs to. By default 'public' if missing.
     */
    @Generated
    private CommunicationCloudEnvironmentModel cloud;

    /**
     * Creates an instance of MicrosoftTeamsUserIdentifierModel class.
     */
    @Generated
    public MicrosoftTeamsUserIdentifierModel() {
    }

    /**
     * Get the userId property: The Id of the Microsoft Teams user. If not anonymous, this is the Entra ID object Id of
     * the user.
     * 
     * @return the userId value.
     */
    @Generated
    public String getUserId() {
        return this.userId;
    }

    /**
     * Set the userId property: The Id of the Microsoft Teams user. If not anonymous, this is the Entra ID object Id of
     * the user.
     * 
     * @param userId the userId value to set.
     * @return the MicrosoftTeamsUserIdentifierModel object itself.
     */
    @Generated
    public MicrosoftTeamsUserIdentifierModel setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * Get the isAnonymous property: True if the Microsoft Teams user is anonymous. By default false if missing.
     * 
     * @return the isAnonymous value.
     */
    @Generated
    public Boolean isAnonymous() {
        return this.isAnonymous;
    }

    /**
     * Set the isAnonymous property: True if the Microsoft Teams user is anonymous. By default false if missing.
     * 
     * @param isAnonymous the isAnonymous value to set.
     * @return the MicrosoftTeamsUserIdentifierModel object itself.
     */
    @Generated
    public MicrosoftTeamsUserIdentifierModel setIsAnonymous(Boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
        return this;
    }

    /**
     * Get the cloud property: The cloud that the Microsoft Teams user belongs to. By default 'public' if missing.
     * 
     * @return the cloud value.
     */
    @Generated
    public CommunicationCloudEnvironmentModel getCloud() {
        return this.cloud;
    }

    /**
     * Set the cloud property: The cloud that the Microsoft Teams user belongs to. By default 'public' if missing.
     * 
     * @param cloud the cloud value to set.
     * @return the MicrosoftTeamsUserIdentifierModel object itself.
     */
    @Generated
    public MicrosoftTeamsUserIdentifierModel setCloud(CommunicationCloudEnvironmentModel cloud) {
        this.cloud = cloud;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userId", this.userId);
        jsonWriter.writeBooleanField("isAnonymous", this.isAnonymous);
        jsonWriter.writeStringField("cloud", this.cloud == null ? null : this.cloud.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftTeamsUserIdentifierModel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftTeamsUserIdentifierModel if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MicrosoftTeamsUserIdentifierModel.
     */
    @Generated
    public static MicrosoftTeamsUserIdentifierModel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftTeamsUserIdentifierModel deserializedMicrosoftTeamsUserIdentifierModel
                = new MicrosoftTeamsUserIdentifierModel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("userId".equals(fieldName)) {
                    deserializedMicrosoftTeamsUserIdentifierModel.userId = reader.getString();
                } else if ("isAnonymous".equals(fieldName)) {
                    deserializedMicrosoftTeamsUserIdentifierModel.isAnonymous
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("cloud".equals(fieldName)) {
                    deserializedMicrosoftTeamsUserIdentifierModel.cloud
                        = CommunicationCloudEnvironmentModel.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMicrosoftTeamsUserIdentifierModel;
        });
    }
}
