// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A Microsoft Teams application.
 */
@Fluent
public final class MicrosoftTeamsAppIdentifierModel implements JsonSerializable<MicrosoftTeamsAppIdentifierModel> {
    /*
     * The Id of the Microsoft Teams application.
     */
    @Generated
    private String appId;

    /*
     * The cloud that the Microsoft Teams application belongs to. By default 'public' if missing.
     */
    @Generated
    private CommunicationCloudEnvironmentModel cloud;

    /**
     * Creates an instance of MicrosoftTeamsAppIdentifierModel class.
     */
    @Generated
    public MicrosoftTeamsAppIdentifierModel() {
    }

    /**
     * Get the appId property: The Id of the Microsoft Teams application.
     * 
     * @return the appId value.
     */
    @Generated
    public String getAppId() {
        return this.appId;
    }

    /**
     * Set the appId property: The Id of the Microsoft Teams application.
     * 
     * @param appId the appId value to set.
     * @return the MicrosoftTeamsAppIdentifierModel object itself.
     */
    @Generated
    public MicrosoftTeamsAppIdentifierModel setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    /**
     * Get the cloud property: The cloud that the Microsoft Teams application belongs to. By default 'public' if
     * missing.
     * 
     * @return the cloud value.
     */
    @Generated
    public CommunicationCloudEnvironmentModel getCloud() {
        return this.cloud;
    }

    /**
     * Set the cloud property: The cloud that the Microsoft Teams application belongs to. By default 'public' if
     * missing.
     * 
     * @param cloud the cloud value to set.
     * @return the MicrosoftTeamsAppIdentifierModel object itself.
     */
    @Generated
    public MicrosoftTeamsAppIdentifierModel setCloud(CommunicationCloudEnvironmentModel cloud) {
        this.cloud = cloud;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appId", this.appId);
        jsonWriter.writeStringField("cloud", this.cloud == null ? null : this.cloud.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftTeamsAppIdentifierModel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftTeamsAppIdentifierModel if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MicrosoftTeamsAppIdentifierModel.
     */
    @Generated
    public static MicrosoftTeamsAppIdentifierModel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftTeamsAppIdentifierModel deserializedMicrosoftTeamsAppIdentifierModel
                = new MicrosoftTeamsAppIdentifierModel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("appId".equals(fieldName)) {
                    deserializedMicrosoftTeamsAppIdentifierModel.appId = reader.getString();
                } else if ("cloud".equals(fieldName)) {
                    deserializedMicrosoftTeamsAppIdentifierModel.cloud
                        = CommunicationCloudEnvironmentModel.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMicrosoftTeamsAppIdentifierModel;
        });
    }
}
