// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The MediaStreamingUpdate model.
 */
@Fluent
public final class MediaStreamingUpdate implements JsonSerializable<MediaStreamingUpdate> {
    /*
     * The contentType property.
     */
    @Generated
    private String contentType;

    /*
     * The mediaStreamingStatus property.
     */
    @Generated
    private MediaStreamingStatus mediaStreamingStatus;

    /*
     * The mediaStreamingStatusDetails property.
     */
    @Generated
    private MediaStreamingStatusDetails mediaStreamingStatusDetails;

    /**
     * Creates an instance of MediaStreamingUpdate class.
     */
    @Generated
    public MediaStreamingUpdate() {
    }

    /**
     * Get the contentType property: The contentType property.
     * 
     * @return the contentType value.
     */
    @Generated
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The contentType property.
     * 
     * @param contentType the contentType value to set.
     * @return the MediaStreamingUpdate object itself.
     */
    @Generated
    public MediaStreamingUpdate setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the mediaStreamingStatus property: The mediaStreamingStatus property.
     * 
     * @return the mediaStreamingStatus value.
     */
    @Generated
    public MediaStreamingStatus getMediaStreamingStatus() {
        return this.mediaStreamingStatus;
    }

    /**
     * Set the mediaStreamingStatus property: The mediaStreamingStatus property.
     * 
     * @param mediaStreamingStatus the mediaStreamingStatus value to set.
     * @return the MediaStreamingUpdate object itself.
     */
    @Generated
    public MediaStreamingUpdate setMediaStreamingStatus(MediaStreamingStatus mediaStreamingStatus) {
        this.mediaStreamingStatus = mediaStreamingStatus;
        return this;
    }

    /**
     * Get the mediaStreamingStatusDetails property: The mediaStreamingStatusDetails property.
     * 
     * @return the mediaStreamingStatusDetails value.
     */
    @Generated
    public MediaStreamingStatusDetails getMediaStreamingStatusDetails() {
        return this.mediaStreamingStatusDetails;
    }

    /**
     * Set the mediaStreamingStatusDetails property: The mediaStreamingStatusDetails property.
     * 
     * @param mediaStreamingStatusDetails the mediaStreamingStatusDetails value to set.
     * @return the MediaStreamingUpdate object itself.
     */
    @Generated
    public MediaStreamingUpdate
        setMediaStreamingStatusDetails(MediaStreamingStatusDetails mediaStreamingStatusDetails) {
        this.mediaStreamingStatusDetails = mediaStreamingStatusDetails;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("mediaStreamingStatus",
            this.mediaStreamingStatus == null ? null : this.mediaStreamingStatus.toString());
        jsonWriter.writeStringField("mediaStreamingStatusDetails",
            this.mediaStreamingStatusDetails == null ? null : this.mediaStreamingStatusDetails.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaStreamingUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaStreamingUpdate if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MediaStreamingUpdate.
     */
    @Generated
    public static MediaStreamingUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaStreamingUpdate deserializedMediaStreamingUpdate = new MediaStreamingUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("contentType".equals(fieldName)) {
                    deserializedMediaStreamingUpdate.contentType = reader.getString();
                } else if ("mediaStreamingStatus".equals(fieldName)) {
                    deserializedMediaStreamingUpdate.mediaStreamingStatus
                        = MediaStreamingStatus.fromString(reader.getString());
                } else if ("mediaStreamingStatusDetails".equals(fieldName)) {
                    deserializedMediaStreamingUpdate.mediaStreamingStatusDetails
                        = MediaStreamingStatusDetails.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMediaStreamingUpdate;
        });
    }
}
