// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Options for media streaming.
 */
@Fluent
public class MediaStreamingOptionsInternal implements JsonSerializable<MediaStreamingOptionsInternal> {
    /*
     * Defines the transport type used for streaming. Note that future values may be introduced that are not currently
     * documented.
     */
    @Generated
    private StreamingTransportTypeInternal transportType
        = StreamingTransportTypeInternal.fromString("MediaStreamingOptionsInternal");

    /*
     * The audio channel type to stream, e.g., unmixed audio, mixed audio.
     */
    @Generated
    private MediaStreamingAudioChannelTypeInternal audioChannelType;

    /**
     * Creates an instance of MediaStreamingOptionsInternal class.
     */
    @Generated
    public MediaStreamingOptionsInternal() {
    }

    /**
     * Get the transportType property: Defines the transport type used for streaming. Note that future values may be
     * introduced that are not currently documented.
     * 
     * @return the transportType value.
     */
    @Generated
    public StreamingTransportTypeInternal getTransportType() {
        return this.transportType;
    }

    /**
     * Get the audioChannelType property: The audio channel type to stream, e.g., unmixed audio, mixed audio.
     * 
     * @return the audioChannelType value.
     */
    @Generated
    public MediaStreamingAudioChannelTypeInternal getAudioChannelType() {
        return this.audioChannelType;
    }

    /**
     * Set the audioChannelType property: The audio channel type to stream, e.g., unmixed audio, mixed audio.
     * 
     * @param audioChannelType the audioChannelType value to set.
     * @return the MediaStreamingOptionsInternal object itself.
     */
    @Generated
    public MediaStreamingOptionsInternal setAudioChannelType(MediaStreamingAudioChannelTypeInternal audioChannelType) {
        this.audioChannelType = audioChannelType;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("audioChannelType",
            this.audioChannelType == null ? null : this.audioChannelType.toString());
        jsonWriter.writeStringField("transportType", this.transportType == null ? null : this.transportType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaStreamingOptionsInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaStreamingOptionsInternal if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MediaStreamingOptionsInternal.
     */
    @Generated
    public static MediaStreamingOptionsInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("transportType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("websocket".equals(discriminatorValue)) {
                    return WebSocketMediaStreamingOptionsInternal.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static MediaStreamingOptionsInternal fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaStreamingOptionsInternal deserializedMediaStreamingOptionsInternal
                = new MediaStreamingOptionsInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("audioChannelType".equals(fieldName)) {
                    deserializedMediaStreamingOptionsInternal.audioChannelType
                        = MediaStreamingAudioChannelTypeInternal.fromString(reader.getString());
                } else if ("transportType".equals(fieldName)) {
                    deserializedMediaStreamingOptionsInternal.transportType
                        = StreamingTransportTypeInternal.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMediaStreamingOptionsInternal;
        });
    }
}
