// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration of Media streaming.
 */
@Fluent
public final class MediaStreamingConfigurationInternal
    implements JsonSerializable<MediaStreamingConfigurationInternal> {
    /*
     * Transport URL for media streaming
     */
    private String transportUrl;

    /*
     * The type of transport to be used for media streaming, eg. Websocket
     */
    private MediaStreamingTransportTypeInternal transportType;

    /*
     * Content type to stream, eg. audio
     */
    private MediaStreamingContentTypeInternal contentType;

    /*
     * Audio channel type to stream, eg. unmixed audio, mixed audio
     */
    private MediaStreamingAudioChannelTypeInternal audioChannelType;

    /*
     * Determines if the media streaming should be started immediately after call is answered or not.
     */
    private Boolean startMediaStreaming;

    /**
     * Creates an instance of MediaStreamingConfigurationInternal class.
     */
    public MediaStreamingConfigurationInternal() {
    }

    /**
     * Get the transportUrl property: Transport URL for media streaming.
     * 
     * @return the transportUrl value.
     */
    public String getTransportUrl() {
        return this.transportUrl;
    }

    /**
     * Set the transportUrl property: Transport URL for media streaming.
     * 
     * @param transportUrl the transportUrl value to set.
     * @return the MediaStreamingConfigurationInternal object itself.
     */
    public MediaStreamingConfigurationInternal setTransportUrl(String transportUrl) {
        this.transportUrl = transportUrl;
        return this;
    }

    /**
     * Get the transportType property: The type of transport to be used for media streaming, eg. Websocket.
     * 
     * @return the transportType value.
     */
    public MediaStreamingTransportTypeInternal getTransportType() {
        return this.transportType;
    }

    /**
     * Set the transportType property: The type of transport to be used for media streaming, eg. Websocket.
     * 
     * @param transportType the transportType value to set.
     * @return the MediaStreamingConfigurationInternal object itself.
     */
    public MediaStreamingConfigurationInternal setTransportType(MediaStreamingTransportTypeInternal transportType) {
        this.transportType = transportType;
        return this;
    }

    /**
     * Get the contentType property: Content type to stream, eg. audio.
     * 
     * @return the contentType value.
     */
    public MediaStreamingContentTypeInternal getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Content type to stream, eg. audio.
     * 
     * @param contentType the contentType value to set.
     * @return the MediaStreamingConfigurationInternal object itself.
     */
    public MediaStreamingConfigurationInternal setContentType(MediaStreamingContentTypeInternal contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the audioChannelType property: Audio channel type to stream, eg. unmixed audio, mixed audio.
     * 
     * @return the audioChannelType value.
     */
    public MediaStreamingAudioChannelTypeInternal getAudioChannelType() {
        return this.audioChannelType;
    }

    /**
     * Set the audioChannelType property: Audio channel type to stream, eg. unmixed audio, mixed audio.
     * 
     * @param audioChannelType the audioChannelType value to set.
     * @return the MediaStreamingConfigurationInternal object itself.
     */
    public MediaStreamingConfigurationInternal
        setAudioChannelType(MediaStreamingAudioChannelTypeInternal audioChannelType) {
        this.audioChannelType = audioChannelType;
        return this;
    }

    /**
     * Get the startMediaStreaming property: Determines if the media streaming should be started immediately after call
     * is answered or not.
     * 
     * @return the startMediaStreaming value.
     */
    public Boolean isStartMediaStreaming() {
        return this.startMediaStreaming;
    }

    /**
     * Set the startMediaStreaming property: Determines if the media streaming should be started immediately after call
     * is answered or not.
     * 
     * @param startMediaStreaming the startMediaStreaming value to set.
     * @return the MediaStreamingConfigurationInternal object itself.
     */
    public MediaStreamingConfigurationInternal setStartMediaStreaming(Boolean startMediaStreaming) {
        this.startMediaStreaming = startMediaStreaming;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transportUrl", this.transportUrl);
        jsonWriter.writeStringField("transportType", this.transportType == null ? null : this.transportType.toString());
        jsonWriter.writeStringField("contentType", this.contentType == null ? null : this.contentType.toString());
        jsonWriter.writeStringField("audioChannelType",
            this.audioChannelType == null ? null : this.audioChannelType.toString());
        jsonWriter.writeBooleanField("startMediaStreaming", this.startMediaStreaming);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaStreamingConfigurationInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaStreamingConfigurationInternal if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MediaStreamingConfigurationInternal.
     */
    public static MediaStreamingConfigurationInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaStreamingConfigurationInternal deserializedMediaStreamingConfigurationInternal
                = new MediaStreamingConfigurationInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("transportUrl".equals(fieldName)) {
                    deserializedMediaStreamingConfigurationInternal.transportUrl = reader.getString();
                } else if ("transportType".equals(fieldName)) {
                    deserializedMediaStreamingConfigurationInternal.transportType
                        = MediaStreamingTransportTypeInternal.fromString(reader.getString());
                } else if ("contentType".equals(fieldName)) {
                    deserializedMediaStreamingConfigurationInternal.contentType
                        = MediaStreamingContentTypeInternal.fromString(reader.getString());
                } else if ("audioChannelType".equals(fieldName)) {
                    deserializedMediaStreamingConfigurationInternal.audioChannelType
                        = MediaStreamingAudioChannelTypeInternal.fromString(reader.getString());
                } else if ("startMediaStreaming".equals(fieldName)) {
                    deserializedMediaStreamingConfigurationInternal.startMediaStreaming
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMediaStreamingConfigurationInternal;
        });
    }
}
